/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.Client;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.login.LoginUI;
import csbase.exception.ConfigurationException;
import csbase.logic.diagnosticservice.DeploymentInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class AboutDialog
extends DesktopComponentDialog {
    private JButton closeButton;

    protected JPanel buildButtonsPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        this.closeButton = new JButton(this.getString("close.button"));
        this.closeButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                int pressed = evt.getKeyCode();
                if (pressed == 10) {
                    AboutDialog.this.close();
                }
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AboutDialog.this.close();
            }
        });
        panel.add(this.closeButton);
        return panel;
    }

    protected JPanel buildMainPanel() {
        String addrServerTxt;
        JLabel versionLabel = new JLabel(this.getString("version.label"));
        JLabel dateLabel = new JLabel(this.getString("date.label"));
        JLabel serverNameLabel = new JLabel(this.getString("server.name.label"));
        String serverAddrStr = this.getString("server.address.label");
        JLabel serverAddrLabel = new JLabel(serverAddrStr);
        String clientNameStr = this.getString("client.name.label");
        JLabel clientNameLabel = new JLabel(clientNameStr);
        String clientAddrStr = this.getString("client.address.label");
        JLabel clientAddrLabel = new JLabel(clientAddrStr);
        String systemStr = this.getString("system.label");
        JLabel systemLabel = new JLabel(systemStr);
        String currClientStr = this.getString("current.client.id.label");
        JLabel currClientLabel = new JLabel(currClientStr);
        String sourceClientStr = this.getString("source.client.id.label");
        JLabel sourceClientLabel = new JLabel(sourceClientStr);
        String jvmVersionStr = this.getString("jvm.version.label");
        JLabel jvmVersionLabel = new JLabel(jvmVersionStr);
        int textCharWidth = 15;
        JTextField versionText = new JTextField(15);
        JTextField dateText = new JTextField(15);
        JTextField serverNameText = new JTextField(15);
        JTextField serverAddrText = new JTextField(15);
        JTextField clientNameText = new JTextField(15);
        JTextField clientAddrText = new JTextField(15);
        JTextField systemText = new JTextField(15);
        JTextField currClientText = new JTextField(15);
        JTextField sourceClientText = new JTextField(15);
        JTextField jvmVersionText = new JTextField(15);
        versionText.setEditable(false);
        dateText.setEditable(false);
        serverNameText.setEditable(false);
        serverAddrText.setEditable(false);
        clientNameText.setEditable(false);
        clientAddrText.setEditable(false);
        systemText.setEditable(false);
        currClientText.setEditable(false);
        sourceClientText.setEditable(false);
        jvmVersionText.setEditable(false);
        Client client = Client.getInstance();
        String serverName = client.getServerName();
        try {
            addrServerTxt = client.getServerAddress();
        }
        catch (ConfigurationException e) {
            addrServerTxt = this.getString("address.value.error");
        }
        serverNameText.setText(serverName);
        serverAddrText.setText(addrServerTxt);
        String clientName = client.getClientName();
        String addrClientTxt = client.getClientAddress();
        if (addrClientTxt == null) {
            addrClientTxt = this.getString("address.value.error");
        }
        clientNameText.setText(clientName);
        clientAddrText.setText(addrClientTxt);
        String systemName = client.getSystemName();
        systemText.setText(systemName);
        versionText.setText(client.getVersion());
        currClientText.setText(client.getClientInstanceId());
        sourceClientText.setText(client.getFatherClientInstanceId());
        jvmVersionText.setText(DeploymentInfo.JAVA_VERSION);
        JComponent[][] cmps = new JComponent[][]{{systemLabel, systemText}, {versionLabel, versionText}, {dateLabel, dateText}, {serverNameLabel, serverNameText}, {serverAddrLabel, serverAddrText}, {clientNameLabel, clientNameText}, {clientAddrLabel, clientAddrText}, {currClientLabel, currClientText}, {sourceClientLabel, sourceClientText}, {jvmVersionLabel, jvmVersionText}};
        JPanel fieldsPanel = GUIUtils.createBasicGridPanel((JComponent[][])cmps);
        JLabel imageLabel = this.createImageLabel();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        if (imageLabel != null) {
            panel.add((Component)imageLabel, new GBC(0, 0).center().insets(20, 20, 20, 20));
        }
        panel.add((Component)fieldsPanel, new GBC(0, 1).center().insets(0, 20, 20, 20).horizontal());
        return panel;
    }

    private JLabel createImageLabel() {
        Configuration configuration;
        try {
            configuration = ConfigurationManager.getInstance().getConfiguration(LoginUI.class);
        }
        catch (ConfigurationManagerException e) {
            return null;
        }
        String propName = "image.path";
        String imagePath = configuration.getOptionalProperty("image.path");
        if (imagePath == null) {
            return null;
        }
        URL imagePathUrl = this.getClass().getResource(imagePath);
        if (imagePathUrl == null) {
            return null;
        }
        ImageIcon systemImage = new ImageIcon(imagePathUrl);
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(systemImage);
        return imageLabel;
    }

    private final String getString(String tag) {
        String className = this.getClass().getSimpleName();
        return LNG.get((String)(className + "." + tag));
    }

    public AboutDialog(JFrame frame) {
        super((Window)frame);
        Client client = Client.getInstance();
        String versionName = client.getVersion();
        String fmtTitle = this.getString("title");
        String systemName = client.getSystemName();
        this.setTitle(String.format(fmtTitle, systemName, versionName));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.buildMainPanel(), "Center");
        mainPanel.add((Component)this.buildButtonsPanel(), "South");
        Container container = this.getContentPane();
        container.add(mainPanel);
        this.pack();
        this.closeButton.requestFocus();
    }
}

