/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels.filters;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.filters.AbstractProjectFilter;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.gui.GBC;

public class ProjectFileSystemLocationPanel
extends AbstractProjectFilter {
    private JTextField projectLocationField;
    private JLabel projectLocationLabel;
    private JPanel labelPanel;
    private JPanel textPanel;

    public ProjectFileSystemLocationPanel(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    protected void initComponents() {
        this.projectLocationField = new JTextField();
        this.projectLocationLabel = new JLabel(this.getString("ProjectFileSystemLocationPanel.project.location.label"));
        this.labelPanel = new JPanel(new GridBagLayout());
        this.textPanel = new JPanel(new GridBagLayout());
        this.setLayout(new GridBagLayout());
    }

    @Override
    protected void buildPanel() {
        this.labelPanel.add((Component)this.projectLocationLabel, new GBC(0, 0));
        this.textPanel.add((Component)this.projectLocationField, new GBC(1, 0).horizontal());
    }

    @Override
    public void runSpecificFilter(List<ProjectsManagerData> projects, List<ProjectsManagerData> filteredProjects) {
        Pattern pattern = this.convertToPattern(this.projectLocationField);
        if (pattern == null) {
            return;
        }
        for (ProjectsManagerData pmd : projects) {
            if (!this.projectMatchesFilter(pattern, pmd)) continue;
            filteredProjects.add(pmd);
        }
    }

    @Override
    public boolean projectMatchesFilter(ProjectsManagerData prj) {
        return this.projectMatchesFilter(this.convertToPattern(this.projectLocationField), prj);
    }

    private boolean projectMatchesFilter(Pattern pattern, ProjectsManagerData prj) {
        if (pattern == null) {
            return false;
        }
        String prjLocation = prj.getLocationInServer();
        if (prjLocation == null || prjLocation.isEmpty()) {
            return false;
        }
        return pattern.matcher(prjLocation).matches();
    }

    @Override
    public void addListener(KeyListener kl) {
        this.projectLocationField.addKeyListener(kl);
    }

    @Override
    public void emptyFilterData() {
        this.projectLocationField.setText("");
    }

    public JPanel getLabelPanel() {
        return this.labelPanel;
    }

    public JPanel getTextPanel() {
        return this.textPanel;
    }
}

