/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.commandsmonitor.models.TablesTabDTO;
import csbase.client.applications.commandsmonitor.table.CommandsTableFactory;
import csbase.client.util.event.EventManager;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Aba contendo tabelas de monitorao de comandos.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class TablesTab extends TablesPanel implements ISelectionListenerTab {

  /**
   * Identificador da aba.
   */
  private String id;
  /**
   * Ttulo da aba.
   */
  private String title;
  
  /**
   * Construtor.
   * 
   * @param tabInfo Informaes da aba.
   * @param tablesFactory Fbrica de tabelas.
   * @param appRegistry Registro da aplicao utilizado para obter a fraseologia
   *        a ser utilizada.
   * @param eventManager gerencia os eventos gerados.
   * 
   * @throws ApplicationException Erro na criao da tabela.
   */
  public TablesTab(TablesTabDTO tabInfo,
    CommandsTableFactory tablesFactory, ApplicationRegistry appRegistry, EventManager eventManager)
    throws ApplicationException {
    super(tabInfo.getTablesId(), tablesFactory, appRegistry, eventManager);
    
    this.id = tabInfo.getId();
    this.title = appRegistry.getString("tab." + id + ".title");
  }
  
  /**
   * Obtm o identificador nico da aba.
   * 
   * @return o identificador nico da aba.
   */
  public String getId() {
    return id;
  }
  
  /**
   * Obtm o ttulo da aba.
   * 
   * @return o ttulo da aba.
   */
  public String getTitle() {
    return title;
  }

  /**
   * {@inheritDoc}
   * 
   * @param selected Indica se essa aba foi selecionada - ganhou foco - ou no.
   *        Se ganhou foco, inicia a monitorao de comandos. Se perdeu o foco,
   *        limpa as clulas selecionadas.
   */
  @Override
  public void onSelectionChanged(boolean selected) {
    if (selected) {
      start();
    }
    else {
      selectionManager.clearSelections();
    }
  }
}
