/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.jobmonitor.columns;

import csbase.client.applications.jobmonitor.rowmodel.JobInfoRow;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class DoubleWithMagnitudeJobInfoColumn
extends AbstractConfigurableColumn<JobInfoRow> {
    private String magnitude;

    public DoubleWithMagnitudeJobInfoColumn(String id, String magnitude) {
        super(id, true, null, null);
        this.magnitude = magnitude;
    }

    public Class<?> getColumnClass() {
        return Double.class;
    }

    public String getColumnName() {
        return this.getId();
    }

    public Object getValue(JobInfoRow obj) {
        String entireValue = obj.get(this.getId());
        Double result = null;
        if (entireValue != null) {
            String valueAsStr = entireValue.substring(0, entireValue.lastIndexOf(this.magnitude));
            result = Double.parseDouble(valueAsStr);
        }
        return result;
    }

    @Override
    public TableCellRenderer createTableCellRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null) {
                    this.setText(value + " " + DoubleWithMagnitudeJobInfoColumn.this.magnitude);
                }
                return this;
            }
        };
    }
}

