/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager;

import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationProject;
import csbase.client.applications.projectsmanager.AbstractProjectsManagerObserver;
import csbase.client.applications.projectsmanager.GetUserNameTask;
import csbase.client.applications.projectsmanager.ProjectCreationRemovalObserver;
import csbase.client.applications.projectsmanager.ProjectSharingStatusObserver;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.actions.AllocateAreaAction;
import csbase.client.applications.projectsmanager.actions.AppendUsersAction;
import csbase.client.applications.projectsmanager.actions.ChangeServerOwnerProjectDialogAction;
import csbase.client.applications.projectsmanager.actions.ChangeStatusAllocateAction;
import csbase.client.applications.projectsmanager.actions.ChangeStatusLockAction;
import csbase.client.applications.projectsmanager.actions.ChangeStatusNoAllocationAction;
import csbase.client.applications.projectsmanager.actions.DeallocateAreaAction;
import csbase.client.applications.projectsmanager.actions.DisplayFilterAction;
import csbase.client.applications.projectsmanager.actions.FillProjectsTableAction;
import csbase.client.applications.projectsmanager.actions.OpenMailDialogAction;
import csbase.client.applications.projectsmanager.actions.OpenProjectAreaOccupationDialogAction;
import csbase.client.applications.projectsmanager.actions.OpenProjectCommentsDialogAction;
import csbase.client.applications.projectsmanager.actions.OpenProjectCreationDialogAction;
import csbase.client.applications.projectsmanager.actions.OpenProjectOccupationDialogAction;
import csbase.client.applications.projectsmanager.actions.RefreshProjectsAction;
import csbase.client.applications.projectsmanager.actions.RemoveProjectAction;
import csbase.client.applications.projectsmanager.actions.RemoveUsersAction;
import csbase.client.applications.projectsmanager.actions.ReplicateSharingDataAction;
import csbase.client.applications.projectsmanager.actions.SearchFilesDialogAction;
import csbase.client.applications.projectsmanager.actions.SetProjectPrivateAction;
import csbase.client.applications.projectsmanager.actions.SetProjectPublicAction;
import csbase.client.applications.projectsmanager.actions.SetProjectSharedAction;
import csbase.client.applications.projectsmanager.actions.ShowProjectHistoryAction;
import csbase.client.applications.projectsmanager.actions.UserRemovalFromProjectAction;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;
import csbase.client.applications.projectsmanager.panels.FilterPanel;
import csbase.client.applications.projectsmanager.panels.InfoPanel;
import csbase.client.applications.projectsmanager.panels.TablePanel;
import csbase.client.applications.projectsmanager.proxy.RetrieveUsersTask;
import csbase.client.project.tasks.CheckAreaReservedTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommonClientProject;
import csbase.logic.CommonProjectInfo;
import csbase.logic.User;
import csbase.logic.UserOutline;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.MenuButton;
import tecgraf.javautils.gui.StandardDialogs;

public class ProjectsManager
extends ApplicationProject
implements Observer {
    private TablePanel tablePanel;
    private InfoPanel infoPanel;
    private FilterPanel filterPanel;
    private FillProjectsTableAction updateProjectsAction;
    private FillProjectsTableAction updateProjectsWithDiskUsageAction;
    private DisplayFilterAction displayFilterAction;
    private final JToolBar toolbar = new JToolBar(0);
    private final List<ProjectsManagerData> allProjectsList = new ArrayList<ProjectsManagerData>();
    private List<ProjectsManagerData> selectedProjectsList;
    private JToggleButton filterButton;
    private JButton projectsSpaceButton;
    private JButton allocateButton;
    private JButton deallocateButton;
    private MenuButton setPublicMenuButton;
    private JButton setPrivateButton;
    private JButton overwriteUsersButton;
    private JButton replicateSharedButton;
    private JButton projectRemovalButton;
    private JButton userRemovalButton;
    private JButton showHistoryButton;
    private JButton writeCommentsButton;
    private JButton mailButton;
    private RefreshProjectsAction multipleProjectSpaceAction;
    private AllocateAreaAction allocateAreaAction;
    private DeallocateAreaAction deallocateAreaAction;
    private SetProjectPublicAction setPublicROProjectSharingStatsAction;
    private SetProjectPublicAction setPublicRWProjectSharingStatsAction;
    private SetProjectPrivateAction setPrivateProjectSharingStatsAction;
    private SetProjectSharedAction setProjectSharedAction;
    private ReplicateSharingDataAction replicateSharingDataAction;
    private ShowProjectHistoryAction showProjectHistoryDialogAction;
    private OpenProjectCommentsDialogAction openProjectCommentsDialogAction;
    private OpenMailDialogAction openMailDialogAction;
    private SearchFilesDialogAction searchFilesDialogAction;
    private OpenProjectCreationDialogAction openProjectCreationDialogAction;
    private ChangeServerOwnerProjectDialogAction changeServerOwnerProjectDialogAction;
    private RemoveProjectAction removeProjectAction;
    private UserRemovalFromProjectAction userRemovalFromProjectAction;
    private OpenProjectOccupationDialogAction openProjectOccupationDialogAction;
    private OpenProjectAreaOccupationDialogAction openProjectAreaOccupationDialogAction;
    private AppendUsersAction appendUsersROAction;
    private AppendUsersAction appendUsersRWAction;
    private RemoveUsersAction removeUsersAction;
    private ChangeStatusLockAction changeStatusLockAction;
    private ChangeStatusAllocateAction changeStatusAllocateAction;
    private ChangeStatusNoAllocationAction changeStatusNoAllocationAction;
    private JMenuItem multipleProjectSpaceItem;
    private JMenuItem createProjectItem;
    private JMenuItem allocateAreaItem;
    private JMenuItem deallocateAreaItem;
    private JMenuItem setLockedStatusItem;
    private JMenuItem setAllocatedStatusItem;
    private JMenuItem setNoAllocationStatusItem;
    private JMenuItem setPublicROProjectSharingStatsItem;
    private JMenuItem setPublicRWProjectSharingStatsItem;
    private JMenuItem setPrivateProjectSharingStatsItem;
    private JMenuItem overwriteUsersItem;
    private JMenuItem appendUsersROItem;
    private JMenuItem appendUsersRWItem;
    private JMenuItem removeUsersItem;
    private JMenuItem replicateSharedItem;
    private JMenuItem projectRemovalItem;
    private JMenuItem userRemovalFromProjectItem;
    private JMenuItem showHistoryItem;
    private JMenuItem writeCommentsItem;
    private JMenuItem mailItem;
    private JMenuItem searchItem;
    private JMenuItem changeServerOwnerProjectItem;
    private ProjectCreationRemovalObserver projectsCreationRemovalObserver;
    private AbstractProjectsManagerObserver projectSharingStatusObserver;
    private boolean areaReserved;

    public ProjectsManager(String id) throws Exception {
        super(id);
        this.defineReservedAreaUsage();
        this.initComponents();
        this.initActions();
        this.initToolbar();
        this.initMenu();
        this.enableItems(false);
        this.ensembleFrame();
        this.refreshProjectsTable(true);
        this.selectCurrentProject();
        ApplicationFrame frame = this.getApplicationFrame();
        frame.setPreferredSize(new Dimension(940, 680));
        frame.pack();
        frame.update(null);
        this.projectsCreationRemovalObserver = new ProjectCreationRemovalObserver(this);
        this.projectSharingStatusObserver = new ProjectSharingStatusObserver(this);
    }

    private void defineReservedAreaUsage() throws Exception {
        CheckAreaReservedTask task = new CheckAreaReservedTask();
        task.execute(this.getApplicationFrame(), ProjectsManagerUI.getString("ProjectsManager.area.reserved.title"), ProjectsManagerUI.getString("ProjectsManager.area.reserved.msg"));
        if (task.wasCancelled()) {
            this.areaReserved = false;
            String title = ProjectsManagerUI.getString("ProjectsManager.area.reserved.cancelled.title");
            String msg = ProjectsManagerUI.getString("ProjectsManager.area.reserved.cancelled.msg");
            StandardDialogs.showErrorDialog((Component)this.getApplicationFrame(), (String)title, (String)msg);
            return;
        }
        if (!task.getStatus()) {
            this.areaReserved = false;
            Exception exception = task.getError();
            throw exception;
        }
        this.areaReserved = (Boolean)task.getResult();
    }

    private void selectCurrentProject() {
        CommonClientProject ccp = this.getApplicationProject();
        if (ccp == null) {
            return;
        }
        int counter = 0;
        String projectName = ccp.getName();
        List<ProjectsManagerData> filteredProjects = this.tablePanel.getVisibleProjects();
        for (ProjectsManagerData pmd : filteredProjects) {
            if (pmd.getProjectName().equals(projectName)) {
                ProjectsManagerData aux = filteredProjects.get(0);
                filteredProjects.set(0, pmd);
                filteredProjects.set(counter, aux);
                this.tablePanel.setTableSelectionInterval(0, 0);
                return;
            }
            ++counter;
        }
    }

    private void initActions() {
        this.multipleProjectSpaceAction = new RefreshProjectsAction(this);
        this.openProjectCreationDialogAction = new OpenProjectCreationDialogAction(this);
        this.allocateAreaAction = new AllocateAreaAction(this);
        this.deallocateAreaAction = new DeallocateAreaAction(this);
        this.setPublicROProjectSharingStatsAction = new SetProjectPublicAction(this, true);
        this.setPublicRWProjectSharingStatsAction = new SetProjectPublicAction(this, false);
        this.setPrivateProjectSharingStatsAction = new SetProjectPrivateAction(this);
        this.setProjectSharedAction = new SetProjectSharedAction(this);
        this.replicateSharingDataAction = new ReplicateSharingDataAction(this);
        this.appendUsersROAction = new AppendUsersAction(this, true);
        this.appendUsersRWAction = new AppendUsersAction(this, false);
        this.removeUsersAction = new RemoveUsersAction(this);
        this.showProjectHistoryDialogAction = new ShowProjectHistoryAction(this);
        this.openProjectCommentsDialogAction = new OpenProjectCommentsDialogAction(this);
        this.openMailDialogAction = new OpenMailDialogAction(this);
        this.searchFilesDialogAction = new SearchFilesDialogAction(this);
        this.removeProjectAction = new RemoveProjectAction(this);
        this.userRemovalFromProjectAction = new UserRemovalFromProjectAction(this);
        this.openProjectOccupationDialogAction = new OpenProjectOccupationDialogAction(this);
        this.openProjectAreaOccupationDialogAction = new OpenProjectAreaOccupationDialogAction(this);
        this.changeStatusLockAction = new ChangeStatusLockAction(this);
        this.changeStatusAllocateAction = new ChangeStatusAllocateAction(this);
        this.changeStatusNoAllocationAction = new ChangeStatusNoAllocationAction(this);
        this.changeServerOwnerProjectDialogAction = new ChangeServerOwnerProjectDialogAction(this);
    }

    private void initComponents() {
        ApplicationFrame frame = this.getApplicationFrame();
        this.displayFilterAction = new DisplayFilterAction(this);
        this.updateProjectsAction = new FillProjectsTableAction(this, ProjectsManager.isCurrentUserAdmin(), false);
        this.updateProjectsWithDiskUsageAction = new FillProjectsTableAction(this, ProjectsManager.isCurrentUserAdmin(), true);
        frame.setLayout(new GridBagLayout());
        this.filterPanel = new FilterPanel(this);
        this.tablePanel = new TablePanel(this);
        this.infoPanel = new InfoPanel(this);
        this.setPublicMenuButton = new MenuButton((Icon)ProjectsManagerScope.PUBLIC.getIcon(), MenuButton.PopupPosition.BOTTOM);
    }

    private void ensembleFrame() {
        ApplicationFrame frame = this.getApplicationFrame();
        frame.add((Component)this.toolbar, new GBC(0, 0).horizontal());
        frame.add((Component)this.tablePanel, new GBC(0, 2).both());
        frame.add((Component)this.infoPanel, new GBC(0, 3).horizontal());
    }

    public final void displayFilters(boolean showFilters) {
        ApplicationFrame ap = this.getApplicationFrame();
        if (showFilters) {
            ap.add((Component)this.filterPanel, new GBC(0, 1).horizontal());
            this.filterButton.setSelected(true);
        } else {
            this.filterPanel.emptyFiltersData();
            this.filterPanel.runFilters(true);
            ap.remove(this.filterPanel);
            this.filterButton.setSelected(false);
        }
        ap.validate();
        ap.repaint();
    }

    private void initToolbar() {
        this.setPublicMenuButton.add((Action)this.setPublicROProjectSharingStatsAction);
        this.setPublicMenuButton.add((Action)this.setPublicRWProjectSharingStatsAction);
        this.toolbar.setFloatable(false);
        this.toolbar.add(this.openProjectCreationDialogAction);
        this.toolbar.addSeparator();
        this.toolbar.add(this.openProjectOccupationDialogAction);
        this.toolbar.add(this.openProjectAreaOccupationDialogAction);
        this.toolbar.addSeparator();
        this.toolbar.add(this.updateProjectsWithDiskUsageAction);
        this.projectsSpaceButton = this.toolbar.add(this.multipleProjectSpaceAction);
        this.filterButton = new JToggleButton(this.displayFilterAction);
        this.filterButton.setSelected(false);
        this.toolbar.add(this.filterButton);
        this.toolbar.addSeparator();
        if (ProjectsManager.isCurrentUserAdmin() && this.hasAreaReserved()) {
            this.toolbar.addSeparator();
            this.allocateButton = this.toolbar.add(this.allocateAreaAction);
            this.deallocateButton = this.toolbar.add(this.deallocateAreaAction);
        }
        this.toolbar.addSeparator();
        this.setPrivateButton = this.toolbar.add(this.setPrivateProjectSharingStatsAction);
        this.overwriteUsersButton = this.toolbar.add(this.setProjectSharedAction);
        this.toolbar.add((Component)this.setPublicMenuButton);
        this.toolbar.addSeparator();
        this.replicateSharedButton = this.toolbar.add(this.replicateSharingDataAction);
        this.toolbar.addSeparator();
        this.projectRemovalButton = this.toolbar.add(this.removeProjectAction);
        this.toolbar.addSeparator();
        if (!ProjectsManager.isCurrentUserAdmin()) {
            this.userRemovalButton = this.toolbar.add(this.userRemovalFromProjectAction);
            this.toolbar.addSeparator();
        }
        this.showHistoryButton = this.toolbar.add(this.showProjectHistoryDialogAction);
        this.writeCommentsButton = this.toolbar.add(this.openProjectCommentsDialogAction);
        this.mailButton = this.toolbar.add(this.openMailDialogAction);
        this.toolbar.addSeparator();
        this.toolbar.add(this.searchFilesDialogAction);
    }

    private void initMenu() {
        ApplicationFrame frame = this.getApplicationFrame();
        JMenu optionsMenu = this.initOptionsMenu();
        JMenu projectsMenu = this.initProjectsMenu();
        JMenuBar menu = new JMenuBar();
        menu.add(optionsMenu);
        menu.add(projectsMenu);
        frame.setJMenuBar(menu);
    }

    private JMenu initOptionsMenu() {
        String generalText = this.getMenuString("general");
        JMenu generalMenu = new JMenu(generalText);
        this.createProjectItem = new JMenuItem(this.openProjectCreationDialogAction);
        this.createProjectItem.setText(this.getString("create.project.text"));
        generalMenu.add(this.createProjectItem);
        generalMenu.addSeparator();
        JMenu reportMenu = this.initReportMenu();
        generalMenu.add(reportMenu);
        generalMenu.add(this.updateProjectsWithDiskUsageAction);
        this.multipleProjectSpaceItem = new JMenuItem(this.multipleProjectSpaceAction);
        generalMenu.add(this.multipleProjectSpaceItem);
        JMenuItem filterItem = new JMenuItem(this.displayFilterAction);
        filterItem.setText(this.getString("filter.text"));
        generalMenu.add(filterItem);
        generalMenu.addSeparator();
        generalMenu.add(new ApplicationExitAction(this));
        return generalMenu;
    }

    private JMenu initReportMenu() {
        String otherText = this.getMenuString("report");
        JMenu occupationMenu = new JMenu(otherText);
        occupationMenu.add(this.openProjectOccupationDialogAction);
        occupationMenu.add(this.openProjectAreaOccupationDialogAction);
        return occupationMenu;
    }

    private JMenu initProjectsMenu() {
        String projectsText = this.getMenuString("projects");
        JMenu projectsMenu = new JMenu(projectsText);
        if (ProjectsManager.isCurrentUserAdmin()) {
            this.allocateAreaItem = new JMenuItem(this.allocateAreaAction);
            this.deallocateAreaItem = new JMenuItem(this.deallocateAreaAction);
            this.setLockedStatusItem = new JMenuItem(this.changeStatusLockAction);
            this.setAllocatedStatusItem = new JMenuItem(this.changeStatusAllocateAction);
            this.setNoAllocationStatusItem = new JMenuItem(this.changeStatusNoAllocationAction);
            this.changeServerOwnerProjectItem = new JMenuItem(this.changeServerOwnerProjectDialogAction);
        }
        this.setPublicROProjectSharingStatsItem = new JMenuItem(this.setPublicROProjectSharingStatsAction);
        this.setPublicRWProjectSharingStatsItem = new JMenuItem(this.setPublicRWProjectSharingStatsAction);
        this.setPrivateProjectSharingStatsItem = new JMenuItem(this.setPrivateProjectSharingStatsAction);
        this.overwriteUsersItem = new JMenuItem(this.setProjectSharedAction);
        this.appendUsersROItem = new JMenuItem(this.appendUsersROAction);
        this.appendUsersRWItem = new JMenuItem(this.appendUsersRWAction);
        this.removeUsersItem = new JMenuItem(this.removeUsersAction);
        this.replicateSharedItem = new JMenuItem(this.replicateSharingDataAction);
        this.projectRemovalItem = new JMenuItem(this.removeProjectAction);
        if (!ProjectsManager.isCurrentUserAdmin()) {
            this.userRemovalFromProjectItem = new JMenuItem(this.userRemovalFromProjectAction);
        }
        this.showHistoryItem = new JMenuItem(this.showProjectHistoryDialogAction);
        this.writeCommentsItem = new JMenuItem(this.openProjectCommentsDialogAction);
        this.mailItem = new JMenuItem(this.openMailDialogAction);
        this.searchItem = new JMenuItem(this.searchFilesDialogAction);
        projectsMenu.addSeparator();
        if (ProjectsManager.isCurrentUserAdmin() && this.hasAreaReserved()) {
            projectsMenu.add(this.allocateAreaItem);
            projectsMenu.add(this.deallocateAreaItem);
            projectsMenu.addSeparator();
            JMenu advancedMenu = new JMenu();
            advancedMenu.add(this.setLockedStatusItem);
            advancedMenu.add(this.setAllocatedStatusItem);
            advancedMenu.add(this.setNoAllocationStatusItem);
            advancedMenu.setText(this.getMenuString("advanced"));
            projectsMenu.add(advancedMenu);
            projectsMenu.addSeparator();
        }
        JMenu publicMenu = new JMenu();
        publicMenu.setText(ProjectsManagerUI.getString("ProjectsManager.set.public.item"));
        publicMenu.add(this.setPublicROProjectSharingStatsItem);
        publicMenu.add(this.setPublicRWProjectSharingStatsItem);
        projectsMenu.add(this.setPrivateProjectSharingStatsItem);
        projectsMenu.add(this.overwriteUsersItem);
        projectsMenu.add(publicMenu);
        projectsMenu.addSeparator();
        JMenu appendMenu = new JMenu();
        appendMenu.setText(ProjectsManagerUI.getString("ProjectsManager.append.users.item"));
        appendMenu.add(this.appendUsersROItem);
        appendMenu.add(this.appendUsersRWItem);
        projectsMenu.add(appendMenu);
        projectsMenu.add(this.removeUsersItem);
        projectsMenu.addSeparator();
        projectsMenu.add(this.replicateSharedItem);
        projectsMenu.addSeparator();
        projectsMenu.add(this.projectRemovalItem);
        if (!ProjectsManager.isCurrentUserAdmin()) {
            projectsMenu.addSeparator();
            projectsMenu.add(this.userRemovalFromProjectItem);
        }
        projectsMenu.addSeparator();
        projectsMenu.add(this.showHistoryItem);
        projectsMenu.add(this.writeCommentsItem);
        projectsMenu.add(this.mailItem);
        projectsMenu.add(this.searchItem);
        if (ProjectsManager.isCurrentUserAdmin()) {
            projectsMenu.add(this.changeServerOwnerProjectItem);
        }
        return projectsMenu;
    }

    public void setSelectedProjectsList(List<ProjectsManagerData> projectList) {
        this.selectedProjectsList = projectList;
        boolean disable = projectList == null || projectList.size() == 0;
        this.enableItems(!disable);
        this.infoPanel.setSelectedProjects(projectList);
    }

    private final String getMenuString(String tag) {
        String menuTag = "ProjectsManager." + tag + ".menu";
        return ProjectsManagerUI.getString(menuTag);
    }

    @Override
    public final void killApplication() {
        ApplicationFrame mainFrame = this.getApplicationFrame();
        this.projectsCreationRemovalObserver.removeItselfAsObserver();
        this.projectSharingStatusObserver.removeItselfAsObserver();
        ((Window)mainFrame).dispose();
    }

    @Override
    protected final boolean userCanKillApplication() {
        return true;
    }

    public final List<ProjectsManagerData> getAllProjects() {
        return this.allProjectsList;
    }

    public final List<ProjectsManagerData> getVisibleProjects() {
        return this.tablePanel.getVisibleProjects();
    }

    public static User getUser() {
        return User.getLoggedUser();
    }

    public static boolean isCurrentUserAdmin() {
        User loggedUser = User.getLoggedUser();
        return loggedUser.isAdmin();
    }

    public List<UserOutline> getUsers() throws Exception {
        RetrieveUsersTask raut = new RetrieveUsersTask(this);
        ApplicationFrame frame = this.getApplicationFrame();
        raut.execute(frame, "", "");
        if (raut.wasCancelled()) {
            String err = this.getString("ProjectsManager.cancelled.message");
            raut.showError(err);
            return null;
        }
        if (!raut.getStatus()) {
            Exception exception = raut.getError();
            throw exception;
        }
        List users = (List)raut.getResult();
        if (users == null) {
            this.showMessage(this.getString("ProjectsManager.error.obtaining.users.message"));
        }
        return users;
    }

    private void enableItems(boolean enabled) {
        this.projectsSpaceButton.setEnabled(enabled);
        this.multipleProjectSpaceItem.setEnabled(enabled);
        if (this.allocateButton != null) {
            this.allocateButton.setEnabled(enabled);
        }
        if (this.allocateAreaItem != null) {
            this.allocateAreaItem.setEnabled(enabled);
        }
        if (this.deallocateButton != null) {
            this.deallocateButton.setEnabled(enabled);
        }
        if (this.deallocateAreaItem != null) {
            this.deallocateAreaItem.setEnabled(enabled);
        }
        if (this.setLockedStatusItem != null) {
            this.setLockedStatusItem.setEnabled(enabled);
        }
        if (this.setAllocatedStatusItem != null) {
            this.setAllocatedStatusItem.setEnabled(enabled);
        }
        if (this.setNoAllocationStatusItem != null) {
            this.setNoAllocationStatusItem.setEnabled(enabled);
        }
        this.setPublicMenuButton.setEnabled(enabled);
        this.setPublicROProjectSharingStatsItem.setEnabled(enabled);
        this.setPublicRWProjectSharingStatsItem.setEnabled(enabled);
        this.setPrivateButton.setEnabled(enabled);
        this.setPrivateProjectSharingStatsItem.setEnabled(enabled);
        this.overwriteUsersButton.setEnabled(enabled);
        this.overwriteUsersItem.setEnabled(enabled);
        this.appendUsersROItem.setEnabled(enabled);
        this.appendUsersRWItem.setEnabled(enabled);
        this.removeUsersItem.setEnabled(enabled);
        this.replicateSharedButton.setEnabled(enabled);
        this.replicateSharedItem.setEnabled(enabled);
        this.projectRemovalButton.setEnabled(enabled);
        this.projectRemovalItem.setEnabled(enabled);
        if (!ProjectsManager.isCurrentUserAdmin()) {
            this.userRemovalButton.setEnabled(enabled);
            this.userRemovalFromProjectItem.setEnabled(enabled);
        }
        this.showHistoryButton.setEnabled(enabled && this.getSelectedProjects().size() == 1);
        this.showHistoryItem.setEnabled(enabled && this.getSelectedProjects().size() == 1);
        this.writeCommentsButton.setEnabled(enabled);
        this.writeCommentsItem.setEnabled(enabled);
        this.mailButton.setEnabled(enabled);
        this.mailItem.setEnabled(enabled);
        if (this.changeServerOwnerProjectItem != null) {
            this.changeServerOwnerProjectItem.setEnabled(enabled);
        }
    }

    public ProjectsManagerData getProject(CommonProjectInfo cpi) {
        return this.getProject(cpi.projectId);
    }

    private ProjectsManagerData getProject(CommonClientProject ccp) {
        return this.getProject(ccp.getId());
    }

    private ProjectsManagerData getProject(Object projectId) {
        if (this.allProjectsList == null) {
            return null;
        }
        for (ProjectsManagerData pmd : this.allProjectsList) {
            if (!pmd.getProjectId().equals(projectId)) continue;
            return pmd;
        }
        return null;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == null || !(o instanceof CommonClientProject)) {
            return;
        }
        CommonClientProject ccp = (CommonClientProject)o;
        ProjectsManagerData pmd = this.getProject(ccp);
        if (pmd == null) {
            pmd = new ProjectsManagerData(ccp.getId(), ccp.getName(), ccp.getUserId());
        }
        this.updateSpecificProject(pmd, ccp);
    }

    private void updateSpecificProject(ProjectsManagerData newProjectData, CommonClientProject newProject) {
        if (newProjectData == null || newProject == null) {
            return;
        }
        GetUserNameTask gunt = new GetUserNameTask(newProject.getUserId());
        if (gunt.wasCancelled()) {
            String err = this.getString("ProjectsManager.cancelled.message");
            StandardErrorDialogs.showErrorDialog((Window)this.getApplicationFrame(), err);
            return;
        }
        if (!gunt.getStatus()) {
            Exception exception = gunt.getError();
            StandardErrorDialogs.showErrorDialog((Window)this.getApplicationFrame(), exception);
            return;
        }
        String username = (String)gunt.getResult();
        if (username == null) {
            String err = this.getString("ProjectsManager.user.not.found.message");
            StandardErrorDialogs.showErrorDialog((Window)this.getApplicationFrame(), err);
            return;
        }
        newProjectData.setOwnerName(username);
        newProjectData.setProjectSpaceAllocation(ProjectSpaceAllocation.NO_ALLOCATION);
        newProjectData.setProjectDescription(newProject.getDescription());
        newProjectData.setCreationDate(newProject.getCreationDate());
        newProjectData.setModificationDate(newProject.getLastModificationDate());
        newProjectData.setSharingType(newProject.getSharingType());
        newProjectData.setUsers(newProject.getUsersRO(), newProject.getUsersRW());
        newProjectData.setServerOwnerName(newProject.getOwnerServerName());
        this.addProject(newProjectData);
    }

    public boolean isFilterOn() {
        return this.filterButton.isSelected();
    }

    public void refreshProjectsTable() {
        this.refreshProjectsTable(false);
    }

    private void refreshProjectsTable(boolean updateFromServer) {
        try {
            if (updateFromServer) {
                this.updateProjectsAction.actionDone();
            }
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog((Window)this.getApplicationFrame(), e);
        }
        this.tablePanel.refreshTable();
    }

    public void clearProjectSelection() {
        this.tablePanel.clearTableSelection();
    }

    public void removeProject(CommonProjectInfo cpi) {
        ProjectsManagerData pmd = this.getProject(cpi.projectId);
        if (pmd == null) {
            return;
        }
        this.allProjectsList.remove(pmd);
        this.tablePanel.removeProjectFromTable(pmd);
    }

    public void removeProjects(List<ProjectsManagerData> projectList) {
        ArrayList<ProjectsManagerData> newList = new ArrayList<ProjectsManagerData>();
        for (ProjectsManagerData prj : this.selectedProjectsList) {
            ProjectSpaceAllocation spaceAllocation = prj.getProjectSpaceAllocation();
            if (!projectList.contains(prj)) {
                newList.add(prj);
                continue;
            }
            if (spaceAllocation == ProjectSpaceAllocation.ALLOCATED) {
                this.updateProjectToWaitingDeallocation(prj);
                newList.add(prj);
                this.tablePanel.refreshTable();
                continue;
            }
            this.allProjectsList.remove(prj);
            this.tablePanel.removeProjectFromTable(prj);
        }
        this.setSelectedProjectsList(newList);
    }

    private void updateProjectToWaitingDeallocation(ProjectsManagerData pmd) {
        pmd.setProjectSpaceAllocation(ProjectSpaceAllocation.WAITING_DEALLOCATION);
        pmd.setAllocatedSpace(0L);
        pmd.setOccupiedSpace(-1.0);
        pmd.setScope(ProjectsManagerScope.NOT_APPLICABLE);
        pmd.setUsers(null, null);
    }

    public void refreshInfoPanel() {
        this.infoPanel.updateFields();
    }

    public void clearInfoFields() {
        this.infoPanel.clearFields();
    }

    public void setFilteredProjects(List<ProjectsManagerData> filteredProjects) {
        this.tablePanel.setVisibleProjects(filteredProjects);
    }

    public void clearAllProjects() {
        this.allProjectsList.clear();
        this.tablePanel.emptyTableData();
    }

    public void clearTable() {
        this.tablePanel.emptyTableData();
    }

    public void clearFilters() {
        this.filterPanel.emptyFiltersData();
    }

    public void addProject(ProjectsManagerData prj) {
        boolean isVisible;
        if (prj == null) {
            return;
        }
        this.allProjectsList.add(prj);
        boolean bl = isVisible = !this.isFilterOn() || this.filterPanel.projectMatchesFilters(prj);
        if (isVisible) {
            this.tablePanel.addProjectToTable(prj);
        }
    }

    public List<ProjectsManagerData> getSelectedProjects() {
        return this.tablePanel.getSelectedProjects();
    }

    public void updateProjectOccupiedSpace(ProjectsManagerData projectsManagerData) {
        String projectName = projectsManagerData.getProjectName();
        Object projectOwner = projectsManagerData.getOwnerId();
        for (ProjectsManagerData pmd : this.allProjectsList) {
            String pName = pmd.getProjectName();
            Object oId = pmd.getOwnerId();
            if (!pName.equals(projectName) || !oId.equals(projectOwner)) continue;
            pmd.setOccupiedSpace(projectsManagerData.getOccupiedSpace());
        }
    }

    public void runFilters(boolean clearSelection) {
        this.filterPanel.runFilters(clearSelection);
    }

    public boolean hasAreaReserved() {
        return this.areaReserved;
    }
}

