/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.table.column;

import java.util.Date;
import java.util.Locale;

import javax.swing.table.TableCellRenderer;

import csbase.client.util.DateTableCellRenderer;
import csbase.logic.CommandInfo;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Coluna contendo a data de submisso do comando.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class SubmissionColumn extends AbstractCommandsTableColumn {

  /**
   * Renderiza a coluna de status utilizando cones para indicar o status do
   * comando.
   */
  private DateTableCellRenderer CELL_RENDERER;

  /**
   * Construtor.
   * 
   * @param id Identificador da coluna.
   * @param appRegistry registro da aplicao que ser utilizado para se obter o
   *        nome da coluna de acordo com o {@link Locale}.
   */
  public SubmissionColumn(String id, ApplicationRegistry appRegistry) {
    super(Date.class, id, appRegistry);
    CELL_RENDERER = new DateTableCellRenderer();
    // A data de submisso s ser nula em caso de erro.
    CELL_RENDERER.setDefaultEmptyValue(getDefaultErrorValue());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(CommandInfo cmd) {
    return cmd.getSubmittedDate();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {
    return CELL_RENDERER;
  }
}
