/*
 * $Id: OpenLogAction.java 72790 2008-02-15 20:05:47Z clinio $
 */
package csbase.client.applications.csvviewer.actions;

import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.csvviewer.CSVViewer;

/**
 * Pede para a aplicao que detm o painel de controle por um novo arquivo de
 * csv e o abre no painel de csv.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class NewCSVAction extends AbstractCSVAction {

  /**
   * Construtor
   * 
   * @param application o aplicativo dono dessa ao.
   */
  public NewCSVAction(CSVViewer application) {
    super(application, ApplicationImages.ICON_NEW_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) {
    CSVViewer application = getApplication();
    if (application.closeFile()) {
      String rowsLabel =
        getApplication().getString(getClass().getSimpleName() + ".rows.label");
      JTextField rowsField = new JTextField();
      String defaultValue = String.valueOf(CSVViewer.DEFAULT_SIZE);
      rowsField.setText(defaultValue);
      String colsLabel =
        getApplication().getString(
          getClass().getSimpleName() + ".columns.label");
      JTextField colsField = new JTextField();
      colsField.setText(defaultValue);

      Object[] components = { rowsLabel, rowsField, colsLabel, colsField };
      JOptionPane pane =
        new JOptionPane(components, JOptionPane.QUESTION_MESSAGE,
          JOptionPane.OK_CANCEL_OPTION);
      JDialog dialog =
        pane.createDialog(application.getApplicationFrame(), application
          .getName());
      dialog.setVisible(true);
      try {
        int value = ((Integer) pane.getValue()).intValue();
        if (value == JOptionPane.OK_OPTION) {
          Integer rows = Integer.valueOf(rowsField.getText().trim());
          Integer cols = Integer.valueOf(colsField.getText().trim());
          if (rows > 0 && cols > 0) {
            application.newCSV(rows, cols);
          }
          else {
            throw new IllegalArgumentException();
          }
        }
      }
      catch (Exception e) {
        String errorMsg =
          getApplication().getString(
            getClass().getSimpleName() + ".invalid.message");
        StandardDialogs.showErrorDialog(application.getApplicationFrame(),
          application.getName(), errorMsg);
      }
    }
  }
}
