/*
 * $Id:$
 */
package csbase.client.applications.filetransferclient.panels.queuepanel;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.table.SortableTable;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.actions.ClearEndedAction;
import csbase.client.applications.filetransferclient.actions.RefreshQueueTableAction;
import csbase.client.applications.filetransferclient.actions.RequestInterruptAction;
import csbase.client.applications.filetransferclient.actions.RequestRemoveAction;
import csbase.client.applications.filetransferclient.panels.core.FileTransferClientPanel;
import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferRequest;

/**
 * Painel da fila de requisies.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FileTransferClientQueuePanel extends FileTransferClientPanel {

  /**
   * Tabela
   */
  final private SortableTable table = new SortableTable();

  /**
   * Criaco da toolbar lateral da tabela
   * 
   * @return a toolbar
   */
  private JToolBar createTableToolbar() {
    final JToolBar toolbar = new JToolBar(JToolBar.VERTICAL);
    toolbar.setFloatable(false);
    final FileTransferClient app = getApplication();
    toolbar.add(new RefreshQueueTableAction(app));
    toolbar.add(new ClearEndedAction(app));
    toolbar.addSeparator();
    toolbar.add(new RequestInterruptAction(app));
    toolbar.add(new RequestRemoveAction(app));
    return toolbar;
  }

  /**
   * 
   */
  private void mountPanel() {
    final String[] colNames =
      new String[] { getString("column.status"), getString("column.type"),
          getString("column.user"), getString("column.percentage"),
          getString("column.file"), getString("column.size"),
          getString("column.global.rate"), getString("column.queue.time"),
          getString("column.start.time"), getString("column.end.time"),
          getString("column.error.message") };
    final QueueTableModel model = new QueueTableModel(colNames);
    table.setModel(model);
    table.setDefaultRenderer(Object.class, new QueueRenderer());
    table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
    table.setNoSortStateEnabled(true);

    final JTableHeader header = table.getTableHeader();
    header.setReorderingAllowed(false);

    final TableColumnModel columnModel = table.getColumnModel();
    final int W = 50;
    columnModel.getColumn(0).setPreferredWidth(W);
    columnModel.getColumn(1).setPreferredWidth(W);
    columnModel.getColumn(2).setPreferredWidth(W * 3);
    columnModel.getColumn(3).setPreferredWidth(W * 2);
    columnModel.getColumn(4).setPreferredWidth(W * 4);
    columnModel.getColumn(5).setPreferredWidth(W * 2);
    columnModel.getColumn(6).setPreferredWidth(W);
    columnModel.getColumn(7).setPreferredWidth(W * 3);
    columnModel.getColumn(8).setPreferredWidth(W * 3);
    columnModel.getColumn(9).setPreferredWidth(W * 3);
    columnModel.getColumn(10).setPreferredWidth(W * 5);

    final JToolBar toolbar = createTableToolbar();

    setLayout(new BorderLayout());
    table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
    final JScrollPane scrollPane = new JScrollPane(table);
    add(scrollPane, BorderLayout.CENTER);
    add(toolbar, BorderLayout.WEST);
    BorderUtil.setLowBorder(this);
  }

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public FileTransferClientQueuePanel(final FileTransferClient application) {
    super(application);
    mountPanel();
  }

  /**
   * Refresh
   */
  public void refresh() {
    final FileTransferClient app = getApplication();
    final FileTransferProxy serviceProxy = app.getServiceProxy();
    User user = null;
    final User loggedUser = User.getLoggedUser();
    if (!loggedUser.getId().equals(User.getAdminId())) {
      user = loggedUser;
    }
    List<FileTransferRequest> list = serviceProxy.getAllRequests(user);
    final QueueTableModel model = (QueueTableModel) table.getModel();

    final int[] sels = table.getSelectedRows();
    model.setRequestList(list);
    for (int sel : sels) {
      final int nrows = table.getRowCount();
      if (sel < nrows) {
        table.addRowSelectionInterval(sel, sel);
      }
    }
  }

  /**
   * Retorna a lsita de requisices selecionadas.
   * 
   * @return a lista
   */
  public List<String> getSelectedRequestsIds() {
    final int[] sels = table.getSelectedRows();
    final ArrayList<String> ids = new ArrayList<String>();
    if (sels == null || sels.length == 0) {
      return ids;
    }

    final QueueTableModel model = (QueueTableModel) table.getModel();
    final List<FileTransferRequest> modelList = model.getRequestList();
    for (int sel : sels) {
      final int modelSel = table.convertRowIndexToModel(sel);
      final FileTransferRequest req = modelList.get(modelSel);
      ids.add(req.getId());
    }

    Collections.unmodifiableList(ids);
    return ids;
  }

  /**
   * Retorna a lista de requisies listadas
   * 
   * @return a lista
   */
  public List<FileTransferRequest> getAllRequests() {
    final QueueTableModel model = (QueueTableModel) table.getModel();
    return model.getRequestList();
  }
}
