package csbase.client.facilities.configurabletable.UI;

import java.util.List;

import csbase.client.facilities.configurabletable.table.ConfigurableTable;

/**
 * Interface que define mtodos que containers especficos para exibir tabelas
 * devem possuir.
 * 
 * @author Tecgraf
 */
public interface UI4Tables {

  /**
   * Identificador do container de tabelas.
   * 
   * @return identificador do container de tabelas.
   */
  String getId();

  /**
   * Obtm a tabela cujo identificador  <code>tableId</code>.
   * 
   * @param tableId - identificador da tabela.
   * @return tabela.
   */
  ConfigurableTable<?> getTableById(String tableId);

  /**
   * Obtm a tabela cujo identificador  <code>tableId</code>.
   * 
   * @param <T> - tipo dos dados exibidos pela tabela.
   * @param tableId - identificador da tabela.
   * @param dataType - tipo dos dados exibidos pela tabela.
   * @return tabela.
   */
  <T> ConfigurableTable<T> getTableById(String tableId, Class<T> dataType);

  /**
   * Obtm todas as tabelas do painel.
   * 
   * @return todas as tabelas do panel.
   */
  List<ConfigurableTable<?>> getAllTables();

  /**
   * Obtm todas as tabelas do painel que exibem objetos do tipo
   * <code>dataType</code>.
   * 
   * @param <T> - tipo dos dados exibidos pelas tabelas.
   * @param dataType - tipo dos dados exibidos pelas tabelas.
   * @return lista de tabelas que exibem dados do tipo <code>dataType</code>.
   */
  <T> List<ConfigurableTable<T>> getAllTables(Class<T> dataType);

  /**
   * Retorna todas as tabelas da aba selecionada.
   * 
   * @return todas as tabelas da aba selecionada.
   */
  List<ConfigurableTable<?>> getTablesFromSelectedComponent();

  /**
   * Obtm todas as tabelas da aba selecionada que exibem objetos do tipo
   * <code>T</code>.
   * 
   * @param <T> - tipo dos objetos exibidos pelas tabelas.
   * @param dataType - tipo dos objetos exibidos pelas tabelas.
   * @return tabelas da aba selecionada que exibem objetos do tipo
   *         <code>T</code>.
   */
  <T> List<ConfigurableTable<T>> getTablesFromSelectedComponent(
    Class<T> dataType);

  /**
   * Obtm o label de uma dada tabela.
   * 
   * @param tableId - identificador da tabela.
   * @return label definido para a tabela.
   */
  String getTableLabel(String tableId);

  /**
   * Constri a interface posicionando as tabelas de acordo com o alinhamento.
   */
  void buildUI();

}
