/*
 * Detalhes da ltima alterao:
 * 
 * $Author$ $Date$
 * $Revision$
 */
package csbase.client.login;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * <p>
 * Representa o contexto inicial de execuo da interface de usurio.
 * </p>
 * 
 * <p>
 * IMPORTANTE: Toda subclasse de {@link InitialContext} deve possuir um
 * construtor pblico que receba um Locale como parmetro.
 * </p>
 *
 * @author Tecgraf/PUC-Rio
 */
public class InitialContext {
  /** O locale definido para execuo da interface de usurio. */
  private Locale locale;

  /**
   * Mapa de parmetros
   */
  Map<String, String> parameterMap = new HashMap<>();

  /**
   * Cria o contexto inicial de execuo da interface de usurio.
   *
   * @param locale O locale definido para execuo da interface de usurio.
   */
  public InitialContext(Locale locale) {
    this.locale = locale;
  }

  /**
   * Construtor
   * 
   * @param locale O locale definido para execuo da interface de usurio.
   * @param parameterMap Mapa de parmetros
   */
  public InitialContext(Locale locale, Map<String, String> parameterMap) {
    this.locale = locale;
    this.parameterMap = parameterMap;
  }

  /**
   * Obtm o mapa de parmetros
   * 
   * @return o mapa.
   */
  public Map<String, String> getParameterMap() {
    return parameterMap;
  }

  /**
   * Obtm o locale definido para execuo da interface de usurio.
   *
   * @return O locale definido para execuo da interface de usurio.
   */
  public final Locale getLocale() {
    return this.locale;
  }
}
