/*
 * $Id:$
 */

package csbase.client.util.iostring;

import java.awt.Window;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.Client;
import csbase.logic.ClientFile;

/**
 * Utilitrio para gravao de texto diretamente em arquivo
 * 
 * @author Tecgraf
 */
public class TextWriter {

  /**
   * Gravao de arquivo da string completa (<b> no  criada task para esse
   * mtodo</b> - ver
   * {@link #writeAllWithTask(Window, ClientFile, String, Charset)}.
   * 
   * @param file arquivo
   * @param text o texto a ser gravado.
   * @param charset charset
   * @param statusDealer objeto para controle de estado da leitura
   * @throws IOException em caso de erro de I/O
   */
  public static void writeAllWithoutTask(final ClientFile file,
    final String text, final Charset charset,
    final TextDealerStatusInterface statusDealer) throws IOException {
    final Charset writeCharset;
    if (charset == null) {
      final Client client = Client.getInstance();
      writeCharset = client.getSystemDefaultCharset();
    }
    else {
      writeCharset = charset;
    }
    int totalBytes = text.length();
    int wroteBytes = 0;

    final OutputStream stream = file.getOutputStream();
    final OutputStreamWriter streamWriter =
      new OutputStreamWriter(stream, writeCharset);
    final BufferedWriter writer = new BufferedWriter(streamWriter);
    final int blockSize = 1024 * 100;

    try {
      while (wroteBytes < totalBytes) {
        if (statusDealer != null && statusDealer.isTextOperationInterrupted()) {
          return;
        }
        int endIndex = wroteBytes + blockSize;
        if (endIndex > totalBytes) {
          endIndex = totalBytes;
        }
        final String strDump = text.substring(wroteBytes, endIndex);
        final char[] charArray = strDump.toCharArray();
        writer.write(charArray, 0, charArray.length);
        wroteBytes += charArray.length;
        final double perc = ((double) wroteBytes) / totalBytes * 100.;
        final int percentage = (int) Math.round(perc);
        if (statusDealer != null) {
          statusDealer.setTextOperationPercentage(percentage);
        }
      }
      if (statusDealer != null) {
        statusDealer.setTextOperationPercentage(100);
      }
    }
    finally {
      if (writer != null) {
        writer.close();
      }
    }
  }

  /**
   * Faz o dump de uma string diretamente em um arquivo.
   * 
   * @param owner a janela me da task executora
   * @param file o arquivo
   * @param content o texto (contedo) da string.
   * @param charset charset-encoding a ser usado na montagem dos bytes (se
   *        ajustado para {@code null}, ser usado o default do sistema conforme
   *        {@code Client#getSystemDefaultCharset())}).
   * @throws Exception em caso de falha.
   */
  static public void writeAllWithTask(final Window owner,
    final ClientFile file, final String content, final Charset charset)
    throws Exception {
    final Charset writeCharset;
    if (charset == null) {
      final Client client = Client.getInstance();
      writeCharset = client.getSystemDefaultCharset();
    }
    else {
      writeCharset = charset;
    }

    final WriterTask task = new WriterTask(file, content, writeCharset);
    String msg = LNG.get("TextWriter.task.message");
    msg = msg + " (" + file.getName() + ")";
    if (!task.execute(owner, "", msg)) {
      final Exception error = task.getError();
      if (error != null) {
        throw error;
      }
    }
  }
}
