/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.tasks;

import csbase.client.project.tasks.CoreTask;
import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileType;
import java.awt.Window;

public class ChangeFileTypeTask
extends CoreTask<Void> {
    private final ClientProjectFile file;
    private final ProjectFileType newType;

    protected void performTask() throws Exception {
        if (this.newType.equals((Object)this.file.getType())) {
            return;
        }
        this.file.changeType(this.newType.getCode());
    }

    public ChangeFileTypeTask(ClientProjectFile file, ProjectFileType newType) {
        if (file == null) {
            throw new IllegalArgumentException("null file not allowed!");
        }
        ProjectFileType unknown = ProjectFileType.getUnknownFileType();
        this.file = file;
        this.newType = newType == null ? unknown : newType;
    }

    public static final boolean runTask(Window window, ClientProjectFile file, ProjectFileType fileType) {
        ChangeFileTypeTask task = new ChangeFileTypeTask(file, fileType);
        String path = file.getStringPath();
        Object[] args = new Object[]{path, fileType};
        boolean executed = task.execute(window, args);
        return executed;
    }
}

