/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies;

import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.DesktopTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.MailServiceInterface;
import java.awt.Window;
import tecgraf.javautils.core.lng.LNG;

public class MailProxy {
    private static void showError(String msg) {
        DesktopFrame mainFrame = DesktopFrame.getInstance();
        if (mainFrame == null) {
            return;
        }
        DesktopComponentFrame jFrame = mainFrame.getDesktopFrame();
        if (jFrame == null) {
            return;
        }
        String title = LNG.get((String)"MAIL_SEND_TITLE");
        StandardErrorDialogs.showErrorDialog((Window)jFrame, title, msg);
    }

    public static boolean mailTo(String senderName, Object userId, String content, boolean showMsg) {
        final MailServiceInterface mailService = ClientRemoteLocator.mailService;
        DesktopFrame mainFrame = DesktopFrame.getInstance();
        if (mainFrame == null || mailService == null) {
            MailProxy.showError(LNG.get((String)"MAIL_NO_SERVER_ERROR"));
            return false;
        }
        final String sndName = senderName;
        final Object uId = userId;
        final String cnt = content;
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                if (!mailService.mailTo(sndName, uId, cnt)) {
                    String err = LNG.get((String)"MAIL_FAILED_MESSAGE");
                    throw new Exception(err);
                }
            }
        };
        String title = LNG.get((String)"MAIL_SEND_TITLE");
        String msg = LNG.get((String)"MAIL_SEND_MESSAGE");
        task.start(mainFrame.getDesktopFrame(), title, msg);
        Exception exception = task.getException();
        if (exception != null) {
            if (showMsg) {
                MailProxy.showError(exception.getMessage());
            }
            return false;
        }
        return true;
    }

    public static boolean mailSupport(String content) {
        final MailServiceInterface mailService = ClientRemoteLocator.mailService;
        DesktopFrame mainFrame = DesktopFrame.getInstance();
        if (mainFrame == null || mailService == null) {
            MailProxy.showError(LNG.get((String)"MAIL_NO_SERVER_ERROR"));
            return false;
        }
        final String cnt = content;
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                if (!mailService.mailSupport(cnt)) {
                    String err = LNG.get((String)"MAIL_SUPPORT_FAILED_MESSAGE");
                    throw new Exception(err);
                }
            }
        };
        String title = LNG.get((String)"MAIL_SEND_TITLE");
        String msg = LNG.get((String)"MAIL_SEND_MESSAGE");
        task.start(mainFrame.getDesktopFrame(), title, msg);
        Exception exception = task.getException();
        if (exception != null) {
            MailProxy.showError(exception.getMessage());
            return false;
        }
        return true;
    }
}

