package csbase.client.algorithms.validation;

import csbase.logic.algorithms.validation.ElementValidationResult;
import csbase.logic.algorithms.validation.Validation;

/**
 * Resultado da validao de um elemento do tipo {@link ViewValidator}
 */
public class ViewValidationResult extends
  ElementValidationResult<ViewValidator> {

  /**
   * Construtor que passa um n de fluxo como elemento. O resultado ser um
   * grupo.
   * 
   * @param view A viso do parmetro que gerou o resultado.
   */
  public ViewValidationResult(ViewValidator view) {
    super(view);
  }

  /**
   * Construtor que incorpora outro resultado (copia) incluindo a viso relativa
   * ao resultado.
   * 
   * @param validation O resultado da validao.
   * @param view A viso do parmetro que gerou o resultado.
   */
  public ViewValidationResult(Validation validation, ViewValidator view) {
    super(validation, view);
  }
}