package csbase.client.applications.algorithmsmanager.report.core;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

/**
 * Classe de base para os dilogos. Cria o bundle e permite que o esc feche a
 * janela
 * 
 *
 * @author Tecgraf/PUC-Rio
 */
public class BasicTestDialog extends JDialog {

  /** Arquivo com os textos */
  private final ResourceBundle i18nBundle;

  /**
   * @param locale o locale
   * @param parentWindow a janela me.
   */
  public BasicTestDialog(Locale locale, Window parentWindow) {
    super(parentWindow);
    /* O locale para os textos */
    i18nBundle = createBundle(locale);

    addEscListener();
    setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
  }

  /**
   * Cria o bundle de internacionalizao.
   * 
   * @param locale O idioma.
   *
   * @return o bundle.
   */
  private ResourceBundle createBundle(Locale locale) {
    try {
      return ResourceBundle.getBundle(this.getClass().getName(), locale);
    }
    catch (MissingResourceException e) {
      return null;
    }
  }

  /**
   * Obtm o texto usando a chave o locale atual
   * 
   * @param key Chave do texto.
   * @return O texto internacionalizado.
   */
  protected String getString(String key) {

    if ((i18nBundle != null) && i18nBundle.containsKey(key)) {
      return i18nBundle.getString(key);
    }

    return key;
  }

  /**
   * Ajusta a tecla esc para fechar o dilogo.
   */
  private void addEscListener() {
    final AbstractAction cancelAction = new AbstractAction() {
      @Override
      public void actionPerformed(final ActionEvent e) {
        dispose();
      }
    };

    final int mode = JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT;
    final InputMap inputMap = rootPane.getInputMap(mode);
    final ActionMap actionMap = rootPane.getActionMap();
    final int esc = KeyEvent.VK_ESCAPE;
    final KeyStroke cancelStroke = KeyStroke.getKeyStroke(esc, 0);
    final String actionMapKey = cancelStroke.toString();
    inputMap.put(cancelStroke, actionMapKey);
    actionMap.put(actionMapKey, cancelAction);
  }
}
