package csbase.client.applications.algorithmsmanager.versiontree;

import javax.swing.ImageIcon;

import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * Interface que modela os dados dos ns de uma rvore de verses de um
 * algoritmo.
 * 
 */
// TODO ANDREA APS ELIMINAR O PACOTE ias, AS REFERENCIAS PARA ESSA INTERFACE
// PODERO SER SUBSTITUIDAS POR AbstractVersionTreeNode, quando VersionNode ou
// VersionTreeNode herdarem de AbstractVersionTreeNode tambm.
public interface VersionNodeInterface {

  /**
   * Obtm o identificador da verso do algoritmo.
   * 
   * @return o identificador da verso do algoritmo
   */
  public AlgorithmVersionId getId();

  /**
   * Compara um n com outro n especificado, segundo algum critrio definido
   * pelo n.
   * 
   * @param node n a ser comparado
   * 
   * @return o resultado da comparao entre os ns
   */
  public int compare(AlgorithmVersionInfo node);

  /**
   * Obtm o n representado por uma verso.
   * 
   * @return o n verso do algoritmo, caso contrrio, retorna null
   */
  public AlgorithmVersionInfo getNode();

  /**
   * Verifica se  o n raiz da rvore de verses do algoritmo.
   * 
   * @return retorna true se for o n raiz da rvore de verses do algoritmo,
   *         caso contrrio, retorna false
   */
  public boolean isRootNode();

  /**
   * Obtm o cone referente ao n.
   * 
   * @return o cone referente ao n
   */
  public ImageIcon getImageIcon();
}
