package csbase.client.applications.flowapplication.filters;

import tecgraf.vix.Message;
import tecgraf.vix.TypeMessage;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.actions.Action;
import csbase.client.applications.flowapplication.graph.actions.GraphAction;
import csbase.client.applications.flowapplication.messages.GetPopupMessage;
import csbase.client.applications.flowapplication.messages.PickGraphMessage;

/**
 * Filtro que adiciona {@link GraphAction aes de menu popup de fluxo de
 * algoritmos} ao menu popup.
 * 
 * @author lmoreira
 */
public abstract class AddGraphPopupActionFilter extends WorkspaceFilter {

  /**
   * Cria a ao.
   * 
   * @param workspace A rea de trabalho (No aceita {@code null}).
   */
  protected AddGraphPopupActionFilter(final Workspace workspace) {
    super(workspace);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean msgHandlerVO(final TypeMessage msg) {
    handleMessage(msg);
    return super.msgHandlerVO(msg);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean msgHandlerVS(final TypeMessage msg) {
    handleMessage(msg);
    return super.msgHandlerVS(msg);
  }

  /**
   * Cria a ao.
   * 
   * @param graph O fluxo de algoritmos (No aceita {@code null}).
   * 
   * @return A ao.
   */
  protected abstract GraphAction createAction(Graph graph);

  /**
   * <p>
   * Trata as {@link Message mensages} relevantes a este filtro e ignora outras
   * mensagens. A nica mensagem relevante  {@link GetPopupMessage}.
   * 
   * @param msg A mensagem.
   */
  private void handleMessage(final TypeMessage msg) {
    if (msg instanceof GetPopupMessage) {
      final GetPopupMessage getPopupMessage = (GetPopupMessage) msg;
      final PickGraphMessage pickGraphMessage = new PickGraphMessage();
      pickGraphMessage.sendVO(this);
      final Graph graph = pickGraphMessage.getGraph();
      if (graph != null) {
        final Action action = createAction(graph);
        if (action != null) {
          getPopupMessage.addPopupAction(action);
        }
      }
    }
  }
}
