/**
 * $Id$
 */
package csbase.client.applications.logadministration;

import csbase.client.applications.ApplicationComponentDialog;
import csbase.logic.LogFileInfo;

/**
 * A classe abstrata <code>LogFileDialog</code> representa um dilogo para a
 * aplicao de administrao de log. Ela recebe da aplicao quais foram os
 * arquivos de log selecionados.
 * 
 * @author Tecgraf
 */
public abstract class LogFileDialog extends
  ApplicationComponentDialog<LogAdministration> {

  /**
   * Arquivos de log
   */
  protected LogFileInfo[] filesInfo;

  /**
   * Construtor
   * 
   * @param application a aplicao que abriu o dilogo
   */
  public LogFileDialog(LogAdministration application) {
    super(application, application.getApplicationFrame(),
      ModalityType.DOCUMENT_MODAL);
  }

  /**
   * Atualiza as informaes dos arquivos de log selecionados
   * 
   * @param infos informaes dos arquivos de log
   */
  public void updateSelectedFiles(final LogFileInfo[] infos) {
    filesInfo = infos.clone();
  }

  /**
   * Limpa as informaes dos aquivos de log
   */
  public void clearSelectedFiles() {
    filesInfo = null;
  }
}