package csbase.client.applications.projectsynchronization;

import csbase.logic.applicationservice.ApplicationRegistry;

import java.awt.CardLayout;
import java.awt.GridLayout;

import javax.swing.JPanel;

public class ContainerSelectionServers {
  private JPanel rootPanel;
  private JPanel projectsPanel;
  private PanelServerSelection serverSelectionA;
  private PanelServerSelection serverSelectionB;
  private ApplicationRegistry registry;
  private String remoteServer;
  private String remotePort;

  public ContainerSelectionServers(
    ApplicationRegistry registry, String remoteServer, String remotePort) {
    this.registry = registry;
    this.remoteServer = remoteServer;
    this.remotePort = remotePort;
  }

  public JPanel getRootPanel() {
    if (rootPanel == null) {
      rootPanel = new JPanel();
      CardLayout cardLayout = new CardLayout();
      cardLayout.setHgap(3);
      cardLayout.setVgap(3);
      rootPanel.setLayout(cardLayout);
      rootPanel.add("projectsPanel", getProjectsPanel());
    }
    return rootPanel;
  }

  public JPanel getProjectsPanel() {
    if (projectsPanel == null) {
      projectsPanel = new JPanel(new GridLayout(1, 2));
      projectsPanel.add(getServerSelectionA());
      projectsPanel.add(getServerSelectionB());
    }
    return projectsPanel;
  }

  public PanelServerSelection getServerSelectionA() {
    if (serverSelectionA == null) {
      serverSelectionA = new PanelServerSelection(
          registry.getString("step1.server.a"), registry, null, null);
    }
    return serverSelectionA;
  }

  public PanelServerSelection getServerSelectionB() {
    if (serverSelectionB == null) {
      serverSelectionB = new PanelServerSelection(
          registry.getString("step1.server.b"), registry, remoteServer,
          remotePort);
    }
    return serverSelectionB;
  }
}
