/**
 * $Id$
 */

package csbase.client.remote;

import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectEvent;
import csbase.logic.ProjectObserver;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;

/**
 * Permite aos clientes observar mudanas em projetos abertos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ClientProjectObserver implements ProjectObserver {
  /**
   * O projeto correspondente a esse observador.
   */
  private CommonClientProject project;

  /**
   * O ouvinte par receber notificaes relaciondas ao projeto referenciado em
   * {@link #project}
   */
  private IMessageListener listener;

  /**
   * Registra no servidor um observador.
   */
  @Override
  public void install() {
    registerProjectEventListerner();
  }

  /**
   * Remove do servidor o registro desse observador.
   */
  @Override
  public void uninstall() {
    MessageProxy.removeListener(listener);
  }

  /**
   * Registra o ouvinte de eventos de projetos.
   */
  private void registerProjectEventListerner() {
    listener = new IMessageListener() {
      @Override
      public void onMessagesReceived(Message... messages) throws Exception {
        for (Message message : messages) {
          ProjectEvent event = (ProjectEvent) message.getBody();
          //TODO Colocar um filtro para que somente as menssagens do projeto sejam encaminahdas
          if (event.projectId.equals(project.getId())) {
            ClientProjectObserver.this.project.update(event);
          }
        }
      }
    };

    MessageProxy.addListener(listener, ProjectEvent.class);
  }

  /**
   * Cria um observador para um projeto.
   * 
   * @param cp O projeto que est usando esse observador.
   * 
   * @throws Exception de rmi.
   */
  public ClientProjectObserver(CommonClientProject cp) throws Exception {
    project = cp;
    install();
  }
}
