/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies;

import csbase.client.desktop.DesktopTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommandInfo;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;
import csbase.logic.ServerGroupInfo;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.SGAServiceInterface;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class SGAProxy {
    private static void showError(String msg, Exception e) {
        String title = LNG.get((String)"SGA_ACCESSING_TITLE");
        if (e != null) {
            StandardErrorDialogs.showErrorDialog(null, title, msg, e);
        } else {
            StandardErrorDialogs.showErrorDialog(null, title, msg);
        }
    }

    public static Hashtable<String, SGASet> getRegisteredServers() {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return null;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                Hashtable<String, SGASet> result = new Hashtable<String, SGASet>();
                Vector sgaNames = sgaService.getAllSGANames();
                if (sgaNames != null && sgaNames.size() > 0) {
                    for (int i = 0; i < sgaNames.size(); ++i) {
                        String sgaName = (String)sgaNames.get(i);
                        result.put(sgaName, sgaService.getSGASet(sgaName));
                    }
                }
                this.setResult(result);
            }
        };
        task.start(null, LNG.get((String)"SGA_ACCESSING_TITLE"), LNG.get((String)"SGA_ACCESSING_MESSAGE"));
        Exception exception = task.getException();
        if (exception != null) {
            SGAProxy.showError(LNG.get((String)"SGA_FAILURE_MESSAGE"), exception);
            return null;
        }
        return (Hashtable)task.getResult();
    }

    public static Vector<String> getAllSGANames() {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return null;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                this.setResult(sgaService.getAllSGANames());
            }
        };
        task.start(null, LNG.get((String)"SGA_ACCESSING_TITLE"), LNG.get((String)"SGA_ACCESSING_MESSAGE"));
        Exception exception = task.getException();
        if (exception != null) {
            SGAProxy.showError(LNG.get((String)"SGA_FAILURE_MESSAGE"), exception);
            return null;
        }
        return (Vector)task.getResult();
    }

    public static SGAInfo[] getAllInfo(final String sgaName) {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return null;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                this.setResult(sgaService.getAllInfo(sgaName));
            }
        };
        task.start(null, LNG.get((String)"SGA_ACCESSING_TITLE"), LNG.get((String)"SGA_ACCESSING_MESSAGE"));
        Exception exception = task.getException();
        if (exception != null) {
            SGAProxy.showError(LNG.get((String)"SGA_FAILURE_MESSAGE"), exception);
            return null;
        }
        return (SGAInfo[])task.getResult();
    }

    public static SGASet getSGASet(final String sgaName) {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return null;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                this.setResult(sgaService.getSGASet(sgaName));
            }
        };
        task.start(null, LNG.get((String)"SGA_ACCESSING_TITLE"), LNG.get((String)"SGA_ACCESSING_MESSAGE"));
        Exception exception = task.getException();
        if (exception != null) {
            SGAProxy.showError(LNG.get((String)"SGA_FAILURE_MESSAGE"), exception);
            return null;
        }
        return (SGASet)task.getResult();
    }

    public static int getCommandsUpdateInterval() {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return -1;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                this.setResult(new Integer(sgaService.getCommandsUpdateInterval()));
            }
        };
        task.start(null, LNG.get((String)"SGA_ACCESSING_TITLE"), LNG.get((String)"SGA_ACCESSING_MESSAGE"));
        Exception exception = task.getException();
        if (exception != null) {
            SGAProxy.showError(LNG.get((String)"SGA_FAILURE_MESSAGE"), exception);
            return -1;
        }
        return (Integer)task.getResult();
    }

    public static int getUpdateInterval() {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return -1;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                this.setResult(new Integer(sgaService.getUpdateInterval()));
            }
        };
        task.start(null, LNG.get((String)"SGA_ACCESSING_TITLE"), LNG.get((String)"SGA_ACCESSING_MESSAGE"));
        Exception exception = task.getException();
        if (exception != null) {
            SGAProxy.showError(LNG.get((String)"SGA_FAILURE_MESSAGE"), exception);
            return -1;
        }
        return (Integer)task.getResult();
    }

    public static CommandInfo getSGACommand(final String sgaName, final String cmdId) {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return null;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                this.setResult(sgaService.getSGACommand(sgaName, cmdId));
            }
        };
        task.start(null, LNG.get((String)"SGA_ACCESSING_TITLE"), LNG.get((String)"SGA_ACCESSING_MESSAGE"));
        Exception exception = task.getException();
        if (exception != null) {
            SGAProxy.showError(LNG.get((String)"SGA_FAILURE_MESSAGE"), exception);
            return null;
        }
        return (CommandInfo)task.getResult();
    }

    public static ServerGroupInfo[] getServerGroups() {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return null;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                this.setResult(sgaService.getServerGroups());
            }
        };
        task.start(null, LNG.get((String)"SGA_ACCESSING_TITLE"), LNG.get((String)"SGA_ACCESSING_MESSAGE"));
        Exception exception = task.getException();
        if (exception != null) {
            SGAProxy.showError(LNG.get((String)"SGA_GETGROUP_FAILURE_MESSAGE"), exception);
            return null;
        }
        return (ServerGroupInfo[])task.getResult();
    }

    public static boolean setServerGroups(final ServerGroupInfo[] groups) {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return false;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                this.setResult(new Boolean(sgaService.setServerGroups(groups)));
            }
        };
        task.start(null, LNG.get((String)"SGA_ACCESSING_TITLE"), LNG.get((String)"SGA_ACCESSING_MESSAGE"));
        Exception exception = task.getException();
        if (exception != null) {
            SGAProxy.showError(LNG.get((String)"SGA_SETGROUP_FAILURE_MESSAGE"), exception);
            return false;
        }
        return (Boolean)task.getResult();
    }

    public static void shutdownSGA(final String sgaName) {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                this.setResult(sgaService.shutdownSGA(sgaName));
            }
        };
        task.start(null, LNG.get((String)"SGA_MGMT_TITLE"), LNG.get((String)"SGA_DISABLE_MESSAGE"));
        Exception exception = task.getException();
        if (exception != null) {
            SGAProxy.showError(LNG.get((String)"SGA_FAILURE_MESSAGE"), exception);
            return;
        }
        if (!((Boolean)task.getResult()).booleanValue()) {
            SGAProxy.showError(String.format(LNG.get((String)"SGA_COMMUNICATION_ERROR"), sgaName), null);
        }
    }

    public static void restartSGA(final String sgaName) {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                this.setResult(sgaService.restartSGA(sgaName));
            }
        };
        task.start(null, LNG.get((String)"SGA_MGMT_TITLE"), LNG.get((String)"SGA_RESTART_MESSAGE"));
        Exception exception = task.getException();
        if (exception != null) {
            SGAProxy.showError(LNG.get((String)"SGA_FAILURE_MESSAGE"), exception);
            return;
        }
        if (!((Boolean)task.getResult()).booleanValue()) {
            SGAProxy.showError(String.format(LNG.get((String)"SGA_COMMUNICATION_ERROR"), sgaName), null);
        }
    }

    public static boolean killCommand(final String sgaName, final String cmdId) {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return false;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                this.setResult(sgaService.killCommand(sgaName, cmdId));
            }
        };
        String title = LNG.get((String)"SGA_MGMT_TITLE");
        String killMsg = LNG.get((String)"SGA_COMMAND_KILL_MESSAGE");
        task.start(null, title, killMsg);
        Exception exception = task.getException();
        if (exception != null) {
            String err = LNG.get((String)"SGA_FAILURE_MESSAGE");
            SGAProxy.showError(err, exception);
            return false;
        }
        Object result = task.getResult();
        if (result != null) {
            Boolean ok = (Boolean)result;
            if (ok.booleanValue()) {
                return true;
            }
            if (User.getLoggedUser().isAdmin()) {
                String confirmMsg = LNG.get((String)"SGA_CONFIRM_KILL_ANYWAY");
                int answer = StandardDialogs.showYesNoDialog(null, (String)title, (Object)confirmMsg);
                if (answer == 0) {
                    task = new DesktopTask(){

                        @Override
                        public void performTask() throws Exception {
                            sgaService.killCommandAnyway(sgaName, cmdId);
                        }
                    };
                    task.start(null, title, killMsg);
                    exception = task.getException();
                    if (exception != null) {
                        String err = LNG.get((String)"SGA_FAILURE_MESSAGE");
                        SGAProxy.showError(err, exception);
                        return false;
                    }
                    return true;
                }
                return false;
            }
            String comErrorMsg = LNG.get((String)"SGA_COMMUNICATION_ERROR");
            SGAProxy.showError(String.format(comErrorMsg, sgaName), null);
        }
        return false;
    }

    public static void shutdownAllSGAs() {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                this.setResult(sgaService.shutdownAllSGAs());
            }
        };
        task.start(null, LNG.get((String)"SGA_MGMT_TITLE"), LNG.get((String)"SGA_DISABLE_ALL_MESSAGE"));
        Exception exception = task.getException();
        if (exception != null) {
            SGAProxy.showError(LNG.get((String)"SGA_FAILURE_MESSAGE"), exception);
            return;
        }
        Collection sgasFailed = (Collection)task.getResult();
        if (sgasFailed.size() > 0) {
            StringBuilder sgaNames = new StringBuilder();
            for (String sgaName : sgasFailed) {
                sgaNames.append("\n - ");
                sgaNames.append(sgaName);
            }
            String message = String.format(LNG.get((String)"SGA_COMMUNICATION_ERROR"), sgaNames);
            SGAProxy.showError(message, null);
        }
    }

    public static void restartAllSGAs() {
        final SGAServiceInterface sgaService = ClientRemoteLocator.sgaService;
        if (sgaService == null) {
            SGAProxy.showError(LNG.get((String)"SGA_NO_SERVER_ERROR"), null);
            return;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                this.setResult(sgaService.restartAllSGAs());
            }
        };
        task.start(null, LNG.get((String)"SGA_MGMT_TITLE"), LNG.get((String)"SGA_RESTART_ALL_MESSAGE"));
        Exception exception = task.getException();
        if (exception != null) {
            SGAProxy.showError(LNG.get((String)"SGA_FAILURE_MESSAGE"), exception);
            return;
        }
        Collection sgasFailed = (Collection)task.getResult();
        if (sgasFailed.size() > 0) {
            StringBuilder sgaNames = new StringBuilder();
            for (String sgaName : sgasFailed) {
                sgaNames.append("\n - ");
                sgaNames.append(sgaName);
            }
            String message = String.format(LNG.get((String)"SGA_COMMUNICATION_ERROR"), sgaNames);
            SGAProxy.showError(message, null);
        }
    }
}

