/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;

public final class ThrowableTabelModel
implements TableModel {
    private static final int CLASS_INDEX = 0;
    private static final int METHOD_INDEX = 1;
    private static final int FILE_INDEX = 2;
    private static final int LINE_INDEX = 3;
    private static final int COLUMN_COUNT = 4;
    private final List tableModelListenerList;
    private final Throwable throwable;

    public ThrowableTabelModel(Throwable throwable) {
        this.throwable = throwable;
        this.tableModelListenerList = new LinkedList();
    }

    @Override
    public int getRowCount() {
        return this.throwable.getStackTrace().length;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return LNG.get((String)"UTIL_CLASS");
            }
            case 1: {
                return LNG.get((String)"UTIL_METHOD");
            }
            case 2: {
                return LNG.get((String)"UTIL_FILE");
            }
            case 3: {
                return LNG.get((String)"UTIL_LINE");
            }
        }
        throw new IllegalArgumentException("columnIndex == " + columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        StackTraceElement[] stackTrace = this.throwable.getStackTrace();
        if (rowIndex >= stackTrace.length) {
            throw new IllegalArgumentException("rowIndex == " + rowIndex + " : rowCount = " + stackTrace.length);
        }
        StackTraceElement stackTraceElement = stackTrace[rowIndex];
        switch (columnIndex) {
            case 0: {
                return stackTraceElement.getClassName();
            }
            case 1: {
                return stackTraceElement.getMethodName();
            }
            case 2: {
                return stackTraceElement.getFileName();
            }
            case 3: {
                return Integer.toString(stackTraceElement.getLineNumber());
            }
        }
        throw new IllegalArgumentException("columnIndex == " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableModelListenerList.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListenerList.remove(l);
    }
}

