package csbase.client.applications.projectsmanager.proxy;

import java.rmi.RemoteException;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.DiskUsageServiceInterface;

/**
 * Task responsvel por obter o tamanho ocupado por um projeto.
 * 
 * @author jnlopes
 */
public class SingleProjectSpaceTask extends ProjectsManagerTask<Double> {

  /**
   * Nome do projeto.
   */
  final private String projectName;

  /**
   * Id do dono do projeto.
   */
  final private String ownerId;

  /**
   * Construtor
   * 
   * @param projectsManager a aplicao
   * @param projectName nome do projeto.
   * @param ownerId id do dono do projeto.
   */
  public SingleProjectSpaceTask(final ProjectsManager projectsManager,
    final String projectName, final String ownerId) {
    super(projectsManager);

    this.projectName = projectName;
    this.ownerId = ownerId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    final Double projectsSpace = getProjectsSpace();
    setResult(projectsSpace);
  }

  /**
   * Obtm o tamanho ocupado por um projeto.
   * 
   * @return Tamanho total ocupado pelo projeto.
   * @throws RemoteException em caso de falha na execuo de mtodo remoto.
   */
  private Double getProjectsSpace() throws RemoteException {
    final DiskUsageServiceInterface dus = ClientRemoteLocator.diskUsageService;
    return dus.getUsedSpaceForProjectMb(ownerId, projectName);
  }

}
