/*
 * $Id$
 */

package csbase.client.desktop;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import csbase.client.Client;
import csbase.client.login.LoginUI;
import csbase.exception.ConfigurationException;
import csbase.logic.diagnosticservice.DeploymentInfo;

/**
 * Dilogo de about do sistema.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class AboutDialog extends DesktopComponentDialog {

  /**
   * Boto de fechamento.
   */
  private JButton closeButton;

  /**
   * Cria o painel de botes.
   * 
   * @return painel
   */
  protected JPanel buildButtonsPanel() {
    final JPanel panel = new JPanel(new FlowLayout());

    closeButton = new JButton(getString("close.button"));

    closeButton.addKeyListener(new KeyAdapter() {
      @Override
      public void keyPressed(final KeyEvent evt) {
        final int pressed = evt.getKeyCode();
        // Se for apertado o botao ENTER
        if (pressed == KeyEvent.VK_ENTER) {
          close();
        }
      }
    });

    closeButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(final ActionEvent ev) {
        close();
      }
    });

    panel.add(closeButton);
    return panel;
  }

  /**
   * Cria o painel de botes.
   * 
   * @return painel
   */
  protected JPanel buildMainPanel() {
    final JLabel versionLabel = new JLabel(getString("version.label"));
    final JLabel dateLabel = new JLabel(getString("date.label"));
    final JLabel serverNameLabel = new JLabel(getString("server.name.label"));
    final String serverAddrStr = getString("server.address.label");
    final JLabel serverAddrLabel = new JLabel(serverAddrStr);
    final String clientNameStr = getString("client.name.label");
    final JLabel clientNameLabel = new JLabel(clientNameStr);
    final String clientAddrStr = getString("client.address.label");
    final JLabel clientAddrLabel = new JLabel(clientAddrStr);
    final String systemStr = getString("system.label");
    final JLabel systemLabel = new JLabel(systemStr);
    final String currClientStr = getString("current.client.id.label");
    final JLabel currClientLabel = new JLabel(currClientStr);
    final String sourceClientStr = getString("source.client.id.label");
    final JLabel sourceClientLabel = new JLabel(sourceClientStr);
    final String jvmVersionStr = getString("jvm.version.label");
    final JLabel jvmVersionLabel = new JLabel(jvmVersionStr);

    final int textCharWidth = 15;
    final JTextField versionText = new JTextField(textCharWidth);
    final JTextField dateText = new JTextField(textCharWidth);
    final JTextField serverNameText = new JTextField(textCharWidth);
    final JTextField serverAddrText = new JTextField(textCharWidth);
    final JTextField clientNameText = new JTextField(textCharWidth);
    final JTextField clientAddrText = new JTextField(textCharWidth);
    final JTextField systemText = new JTextField(textCharWidth);
    final JTextField currClientText = new JTextField(textCharWidth);
    final JTextField sourceClientText = new JTextField(textCharWidth);
    final JTextField jvmVersionText = new JTextField(textCharWidth);

    versionText.setEditable(false);
    dateText.setEditable(false);
    serverNameText.setEditable(false);
    serverAddrText.setEditable(false);
    clientNameText.setEditable(false);
    clientAddrText.setEditable(false);
    systemText.setEditable(false);
    currClientText.setEditable(false);
    sourceClientText.setEditable(false);
    jvmVersionText.setEditable(false);

    final Client client = Client.getInstance();
    final String serverName = client.getServerName();
    String addrServerTxt;
    try {
      addrServerTxt = client.getServerAddress();
    }
    catch (final ConfigurationException e) {
      addrServerTxt = getString("address.value.error");
    }
    serverNameText.setText(serverName);
    serverAddrText.setText(addrServerTxt);

    final String clientName = client.getClientName();
    String addrClientTxt = client.getClientAddress();
    if (addrClientTxt == null) {
      addrClientTxt = getString("address.value.error");
    }
    clientNameText.setText(clientName);
    clientAddrText.setText(addrClientTxt);

    final String systemName = client.getSystemName();
    systemText.setText(systemName);

    versionText.setText(client.getVersion());

    currClientText.setText(client.getClientInstanceId());
    sourceClientText.setText(client.getFatherClientInstanceId());

    jvmVersionText.setText(DeploymentInfo.JAVA_VERSION);

    final JComponent[][] cmps =
      new JComponent[][] { { systemLabel, systemText },
          { versionLabel, versionText }, { dateLabel, dateText },
          { serverNameLabel, serverNameText },
          { serverAddrLabel, serverAddrText },
          { clientNameLabel, clientNameText },
          { clientAddrLabel, clientAddrText },
          { currClientLabel, currClientText },
          { sourceClientLabel, sourceClientText },
          { jvmVersionLabel, jvmVersionText } };

    final JPanel fieldsPanel = GUIUtils.createBasicGridPanel(cmps);

    final JLabel imageLabel = createImageLabel();
    final JPanel panel = new JPanel();
    panel.setLayout(new GridBagLayout());

    // imagem do topo
    if (imageLabel != null) {
      panel.add(imageLabel, new GBC(0, 0).center().insets(20, 20, 20, 20));
    }

    panel.add(fieldsPanel, new GBC(0, 1).center().insets(0, 20, 20, 20)
      .horizontal());
    return panel;
  }

  /**
   * Cria a imagem do dilogo (com base no LoginUI, se tiver sendo usado)
   * 
   * @return A imagem , ou null, caso no tenha sido informada.
   */
  private JLabel createImageLabel() {
    final Configuration configuration;
    try {
      configuration =
        ConfigurationManager.getInstance().getConfiguration(LoginUI.class);
    }
    catch (final ConfigurationManagerException e) {
      return null;
    }
    final String propName = "image.path";
    final String imagePath = configuration.getOptionalProperty(propName);
    if (imagePath == null) {
      return null;
    }

    final URL imagePathUrl = this.getClass().getResource(imagePath);
    if (imagePathUrl == null) {
      return null;
    }

    final ImageIcon systemImage = new ImageIcon(imagePathUrl);
    final JLabel imageLabel = new JLabel();
    imageLabel.setIcon(systemImage);
    return imageLabel;
  }

  /**
   * Busca de string de internacionalizao.
   * 
   * @param tag o tag para a classe
   * @return o texto
   */
  final private String getString(final String tag) {
    final String className = this.getClass().getSimpleName();
    return LNG.get(className + "." + tag);
  }

  /**
   * Construtor
   * 
   * @param frame o desktop do sistema.
   */
  public AboutDialog(final JFrame frame) {
    super(frame);

    final Client client = Client.getInstance();
    final String versionName = client.getVersion();
    final String fmtTitle = getString("title");
    final String systemName = client.getSystemName();
    setTitle(String.format(fmtTitle, systemName, versionName));

    final JPanel mainPanel = new JPanel();
    mainPanel.setLayout(new BorderLayout());
    mainPanel.add(buildMainPanel(), BorderLayout.CENTER);
    mainPanel.add(buildButtonsPanel(), BorderLayout.SOUTH);
    final Container container = this.getContentPane();
    container.add(mainPanel);
    pack();
    closeButton.requestFocus();
  }
}
