/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.implementations;

import csbase.client.applications.algorithmsmanager.report.core.AbstractTest;
import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import csbase.logic.Platform;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public class TestMissingPlatform
extends AbstractTest<AlgorithmInfo> {
    private final List<String> existingPlataforms = new ArrayList<String>();

    public TestMissingPlatform(List<Platform> registeredPlatform, Window window) {
        super(window, LNG.get((String)"TestMissingPlatform.task.title"), LNG.get((String)"TestMissingPlatform.task.message"));
        for (Platform platform : registeredPlatform) {
            this.existingPlataforms.add(platform.getName());
        }
    }

    @Override
    public List<IResultMessage<AlgorithmInfo>> doTest(AlgorithmInfo algorithmInfo) {
        ArrayList<IResultMessage<AlgorithmInfo>> list = new ArrayList<IResultMessage<AlgorithmInfo>>();
        for (AlgorithmVersionInfo version : algorithmInfo.getVersions()) {
            if (version.getType() != AlgorithmConfigurator.ConfiguratorType.SIMPLE) continue;
            ArrayList<String> missing = new ArrayList<String>();
            ArrayList<String> extra = new ArrayList<String>();
            Map platforms = version.getPlatforms();
            for (String platform : this.existingPlataforms) {
                List exeInfo = (List)platforms.get(platform);
                if (exeInfo != null && exeInfo.size() > 0) continue;
                missing.add(platform);
            }
            for (String platform : platforms.keySet()) {
                if (this.existingPlataforms.contains(platform)) continue;
                extra.add(platform);
            }
            String missingText = ((Object)missing).toString();
            String extraText = ((Object)extra).toString();
            ResultMessage<AlgorithmInfo> message = null;
            if (missing.size() == 0 && extra.size() == 0) {
                message = new ResultMessage<AlgorithmInfo>(algorithmInfo, TestStatus.OK, LNG.get((String)"TestMissingPlatform.perfect.match", (Object[])new String[]{version.toString()}));
            } else if (platforms.size() <= 0) {
                message = new ResultMessage<AlgorithmInfo>(algorithmInfo, TestStatus.ERROR, LNG.get((String)"TestMissingPlatform.missing.all", (Object[])new String[]{version.toString()}));
            } else if (extra.size() > 0) {
                if (missing.size() == this.existingPlataforms.size()) {
                    message = new ResultMessage<AlgorithmInfo>(algorithmInfo, TestStatus.WARNING, LNG.get((String)"TestMissingPlatform.missing.all.with.extras", (Object[])new String[]{version.toString(), extraText}));
                } else if (missing.size() < this.existingPlataforms.size() && missing.size() > 0) {
                    message = new ResultMessage<AlgorithmInfo>(algorithmInfo, TestStatus.WARNING, LNG.get((String)"TestMissingPlatform.missing.and.extras", (Object[])new String[]{version.toString(), missingText, extraText}));
                } else if (missing.size() == 0) {
                    message = new ResultMessage<AlgorithmInfo>(algorithmInfo, TestStatus.WARNING, LNG.get((String)"TestMissingPlatform.only.extras", (Object[])new String[]{version.toString(), extraText}));
                }
            }
            if (message == null) continue;
            list.add(message);
        }
        return list;
    }

    @Override
    public String getName() {
        return LNG.get((String)"TestMissingPlatform.name");
    }

    @Override
    public String getDescription() {
        return LNG.get((String)"TestMissingPlatform.description");
    }

    @Override
    public Class<AlgorithmInfo> getSubjectClass() {
        return AlgorithmInfo.class;
    }

    @Override
    public String getSubjectName(AlgorithmInfo subject) {
        return subject.getName();
    }
}

