/*
 * $Id$
 */

package csbase.client.applications.desktoplauncher.actions;

import java.awt.event.ActionEvent;

import csbase.client.applications.desktoplauncher.DesktopLauncher;
import csbase.client.applications.desktoplauncher.DesktopLauncherEventHandler;

/**
 * Ação para ocultar o desktop-filho.
 * 
 * @author Tecgraf/PUC-Rio
 */
abstract public class DesktopVisibilityAction extends DesktopLauncherAction {

  /**
   * Indicativo.
   */
  final private boolean flag;

  /**
   * Construtor
   * 
   * @param application aplicação.
   * @param flag indicativo.
   */
  public DesktopVisibilityAction(DesktopLauncher application, final boolean flag) {
    super(application);
    this.flag = flag;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) {
    final DesktopLauncherEventHandler eventHandler = getEventHandler();
    if (eventHandler == null) {
      return;
    }
    final boolean treated = eventHandler.fireDesktopVisibilityEvent(flag);
    if (!treated) {
      final String err =
        getString("DesktopVisibilityAction.event.not.sent.error");
      final DesktopLauncher application = getApplication();
      application.showError(err);
    }
  }
}
