/*
 * $Id$
 */

package csbase.client.applications.filetransferclient.actions;

import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.localpanel.FileTransferClientLocalPanel;
import csbase.logic.ClientProjectFile;

/**
 * Ao de troca de diretrio local
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ChangeLocalDirectoryAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(final JComponent component) {
    final FileTransferClient application = getApplication();
    final FileTransferClientLocalPanel localPanel = application.getLocalPanel();
    final List<ClientProjectFile> selFiles = localPanel.getSelectedFiles();
    if (selFiles == null || selFiles.size() <= 0) {
      return;
    }

    if (selFiles.size() != 1) {
      final String msg = getString("multiple.elements.error");
      application.showError(msg);
      return;
    }

    final ClientProjectFile selFile = selFiles.get(0);
    if (selFile == null || !selFile.isDirectory()) {
      return;
    }
    
    localPanel.setLocalDirectory(selFile);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Construtor
   * 
   * @param application a aplicaco
   */
  public ChangeLocalDirectoryAction(final FileTransferClient application) {
    super(application);
  }

}
