package csbase.client.applications.flowapplication.multiflow.tree;

import java.util.ArrayList;
import java.util.List;

import javax.swing.tree.DefaultMutableTreeNode;

import csbase.logic.algorithms.flows.Flow;

/**
 * N da rvore de seleo de parmetros que representa um fluxo.
 */
public class RootNode extends DefaultMutableTreeNode implements
  ParameterSelectionNode {

  /**
   * Construtor.
   * 
   * @param flow o fluxo.
   */
  public RootNode(Flow flow) {
    super(flow, true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Flow getUserObject() {
    return (Flow) super.getUserObject();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<ParameterSelection> getParameterSelection() {
    List<ParameterSelection> selection = new ArrayList<ParameterSelection>();
    for (Object child : children) {
      AlgorithmNode node = (AlgorithmNode) child;
      selection.addAll(node.getParameterSelection());
    }
    return selection;
  }

}
