/**
 * $Id$
 */
package csbase.client.applications.serverdiagnostic.monitor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;

import javax.swing.JComponent;

/**
 * Painel que contm um grfico representando a quantidade utilizada e livre de
 * um disco.
 * 
 * @author Tecgraf
 */
public class DiskUsagePanel extends JComponent {
  /**
   * Percentual utilizado do disco
   */
  private double usedPerc;
  /**
   * Percentual livre do disco
   */
  private double freePerc;
  /**
   * Altura default
   */
  private static final int HEIGHT = 25;

  /**
   * Construtor do painel. As quantidades utilizada e livre devem estar na mesma
   * escala.
   * 
   * @param used quantidade do disco utilizada
   * @param free quantidade do disco livre
   */
  public DiskUsagePanel(double used, double free) {
    this.usedPerc = used / (used + free);
    this.freePerc = free / (used + free);

  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Dimension getPreferredSize() {
    return new Dimension(this.getWidth(), 46);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Dimension getSize() {
    return new Dimension(this.getWidth(), 46);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Dimension getMinimumSize() {
    return new Dimension(this.getWidth(), 46);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void paint(Graphics g) {
    super.paintComponent(g);

    int usedWidth = new Double(getWidth() * this.usedPerc).intValue();
    int freeWidth = new Double(getWidth() * this.freePerc).intValue();

    final Graphics2D g2d = (Graphics2D) g.create();

    g2d.setStroke(new BasicStroke(1));
    g2d.setColor(Color.LIGHT_GRAY);
    g2d.fillRect(0, 0, usedWidth, HEIGHT);
    g2d.setColor(Color.WHITE);
    g2d.fillRect(0 + usedWidth, 0, freeWidth, HEIGHT);

    g2d.setColor(Color.BLACK);
    g2d.drawRect(0, 0, getWidth() - 1, HEIGHT);

    g2d.setColor(Color.BLACK);
    drawCenteredTextAtPosition(
      NumberFormat.getPercentInstance().format(this.usedPerc), g2d,
      usedWidth / 2, HEIGHT / 2);
    drawCenteredTextAtPosition(
      NumberFormat.getPercentInstance().format(this.freePerc), g2d, usedWidth
        + ((getWidth() - usedWidth) / 2), HEIGHT / 2);

    g2d.dispose();
  }

  /**
   * Desenha um texto alinhado no centro das coordenadas informadas;
   * 
   * @param str o texto
   * @param g o contexto Graphics
   * @param x a coordenada x
   * @param y a coordenada y
   */
  private void drawCenteredTextAtPosition(String str, Graphics g, int x, int y) {
    FontMetrics metrics = g.getFontMetrics();
    Rectangle2D bounds = metrics.getStringBounds(str, g);
    int new_x = (int) (x - bounds.getCenterX());
    int new_y = (int) (y - bounds.getCenterY());
    g.drawString(str, new_x, new_y);
  }
}
