/*
 * $Id$
 */

package csbase.client.facilities.commandtable;

import csbase.logic.CommandInfo;
import csbase.logic.MonitoringSet;

/**
 * @author ururahy
 * 
 */
public class CommandMonitoringSet implements MonitoringSet {

  /**
   * Informativo
   */
  private final CommandInfo monitoring;

  /**
   * Construtor.
   * 
   * @param monitoring informativo
   */
  public CommandMonitoringSet(CommandInfo monitoring) {
    this.monitoring = monitoring;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getKey() {
    return monitoring.getId();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(MonitoringSet set) {
    CommandMonitoringSet other = (CommandMonitoringSet) set;
    CommandInfo otherMonitoring = other.getCommandInfo();
    return (monitoring.getId().equals(otherMonitoring.getId()));
  }

  /**
   * Obtm as informaes de monitorao do comando.
   * 
   * @return as informaes de monitorao do comando.
   */
  public CommandInfo getCommandInfo() {
    return monitoring;
  }
}
