package csbase.client.preferences.util;

import csbase.client.preferences.PreferenceCategory;

/**
 * Classe responsvel por internacionalizar rtulos, descries e valores de
 * preferncias.
 * 
 * @see PreferenceCategory PreferenceValue PreferenceEditor
 * 
 * @author Tecgraf
 */
public abstract class PreferenceBundle {

  /**
   * Obtm a string internacionalizada.
   * 
   * @param key chave.
   * @return mensagem internacionalizada.
   */
  public abstract String get(String key);

  /**
   * Verifica se existe propriedade associada a chave.
   * 
   * @param key chave.
   * @return true se existe a propriedade, false caso contrrio.
   */
  public abstract boolean has(String key);
}
