/*
 * $Id$
 */
package csbase.client.project.action;

import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectFileContainer;
import csbase.logic.ClientProjectFile;
import csbase.remote.ClientRemoteLocator;

/**
 * Classe responsvel pela ao de troca de estado de arquivo "em construo"
 * para o estado regular. A motivao desse comportamento  que existem algumas
 * situaes em que o arquivo fica indefinidamente em construo. Esta ao
 * reverte o estado do arquivo. Este  um item de menu avanado e o usurio deve
 * ser avisado do impacto de tal alterao.
 */
public class CommonFileChangeStateAction extends CommonProjectAction {

  /**
   * Construtor.
   * 
   * @param container o container do projeto
   */
  public CommonFileChangeStateAction(ProjectFileContainer container) {
    super(container);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    final ClientProjectFile file = getSelectedFile();
    String fileName = file.getName();
    String title = LNG.get("CommonFileChangeStateAction.title");
    String text =
      String.format(LNG.get("CommonFileChangeStateAction.confirmation"),
        fileName);

    int option =
      StandardDialogs.showOptionDialog(getWindow(), title, text,
        new String[] { LNG.get("CommonFileChangeStateAction.button.change"),
            LNG.get("CommonFileChangeStateAction.button.cancel") });

    if (option != 0) {
      return;
    }

    RemoteTask<Boolean> task = new RemoteTask<Boolean>() {
      @Override
      protected void performTask() throws Exception {
        ClientRemoteLocator.projectService.setUnderConstruction(
          file.getProjectId(), file.getPath(), false);
      }
    };

    boolean result =
      task
        .execute(getWindow(), title, String.format(
          LNG.get("CommonFileChangeStateAction.info.changind.state"), fileName));
    if (result) {
      showError(title, String.format(
        LNG.get("CommonFileChangeStateAction.error.changind.state"), fileName));
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return LNG.get("CommonFileChangeStateAction.name");
  }

}
