/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.logic.ClientProjectFile;

public class ProjectTreePath {
    private ClientProjectFile file;
    private String[] path;
    private ClientProjectFile parent;

    public boolean exists() {
        return this.file != null;
    }

    public String[] getPath() {
        return this.file == null ? this.path : this.file.getPath();
    }

    public ClientProjectFile getFile() {
        return this.file;
    }

    public ClientProjectFile getParent() {
        return this.parent;
    }

    public String getName() {
        return this.path[this.path.length - 1];
    }

    public static String makePath(String sep, String[] path) {
        if (sep == null || path == null || path.length <= 0) {
            return "";
        }
        String dir = "";
        for (int i = 0; i < path.length - 1; ++i) {
            dir = dir + path[i] + sep;
        }
        dir = dir + path[path.length - 1];
        return dir;
    }

    public static String makePath(String project, String sep, String[] path) {
        if (sep == null || project == null) {
            return "";
        }
        String dir = "[" + project + "] : " + ProjectTreePath.makePath("/", path);
        return dir;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProjectTreePath)) {
            return false;
        }
        String[] path = ((ProjectTreePath)o).getPath();
        String[] thisPath = this.getPath();
        if (thisPath.length != path.length) {
            return false;
        }
        for (int i = 0; i < thisPath.length; ++i) {
            if (thisPath[i].equals(path[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        String[] thisPath = this.getPath();
        if (thisPath == null || thisPath.length == 0 || thisPath[0] == null) {
            return "path attribute null or zero".hashCode();
        }
        return thisPath[0].hashCode();
    }

    public String toString() {
        String toString = "";
        String separator = "";
        String[] path = this.getPath();
        for (int i = 0; i < path.length; ++i) {
            toString = toString + separator;
            toString = toString + path[i];
            separator = "/";
        }
        return toString;
    }

    public ProjectTreePath(ClientProjectFile file) {
        this.file = file;
        this.parent = file.getParent();
    }

    public ProjectTreePath(String[] path, ClientProjectFile dir) {
        this.path = path;
        this.parent = dir;
    }
}

