/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.view.flow;

import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.view.AbstractAlgorithmConfiguratorPanel;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AskForParameterValuesActionFilter;
import csbase.client.applications.flowapplication.filters.HighlightElementFilter;
import csbase.client.applications.flowapplication.filters.HintElementFilter;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.zoom.ZoomControl;
import csbase.client.applications.flowapplication.zoom.ZoomModel;
import csbase.client.desktop.RemoteTask;
import csbase.client.kernel.ClientException;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Collection;
import javax.swing.JScrollPane;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

public class FlowAlgorithmConfiguratorPanel
extends AbstractAlgorithmConfiguratorPanel<FlowAlgorithmConfigurator> {
    private Graph graph;
    private Workspace workspace;

    public FlowAlgorithmConfiguratorPanel(Window owner, FlowAlgorithmConfigurator configurator, ParameterView.Mode mode) throws ClientException {
        super(owner, configurator, mode);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public FlowAlgorithmConfigurator getConfigurator() {
        FlowAlgorithmConfigurator algorithmConfigurator = (FlowAlgorithmConfigurator)super.getConfigurator();
        if (this.getGraph() == null) {
            return algorithmConfigurator;
        }
        AlgorithmVersionInfo version = algorithmConfigurator.getAlgorithmVersion();
        Flow flow = this.getGraph().toFlow();
        if (version == null) {
            String filePath = algorithmConfigurator.getFilePath();
            if (filePath == null) {
                return new FlowAlgorithmConfigurator(flow);
            }
            return new FlowAlgorithmConfigurator(filePath, flow);
        }
        return new FlowAlgorithmConfigurator(version, flow);
    }

    @Override
    public void resetValues() {
        super.resetValues();
        Collection<GraphNode> nodes = this.graph.getNodeCollection();
        for (GraphNode node : nodes) {
            node.getAlgorithmConfiguratorView().getConfigurator().resetValues();
        }
    }

    @Override
    protected AbstractAlgorithmConfiguratorPanel.AbstractParametersPanel createParametersReportPanel() throws ClientException {
        return new FlowParametersReportPanel();
    }

    @Override
    protected AbstractAlgorithmConfiguratorPanel.AbstractParametersPanel createParametersConfigurationPanel() throws ClientException {
        return new FlowParametersConfigurationPanel();
    }

    private final class FlowParametersReportPanel
    extends AbstractFlowParametersPanel {
        private ZoomControl zoomControl;

        protected FlowParametersReportPanel() throws ClientException {
        }

        @Override
        protected void initialize(Workspace workspaceArg) {
            this.setLayout(new BorderLayout());
            JScrollPane scrollPane = new JScrollPane(workspaceArg);
            this.add((Component)scrollPane, "Center");
            ZoomModel zoomModel = workspaceArg.getZoomModel();
            this.zoomControl = new ZoomControl(zoomModel);
            this.add((Component)this.zoomControl, "North");
        }

        @Override
        public Dimension getMinimumSize() {
            return this.zoomControl.getPreferredSize();
        }
    }

    private final class FlowParametersConfigurationPanel
    extends AbstractFlowParametersPanel {
        protected FlowParametersConfigurationPanel() throws ClientException {
        }

        @Override
        protected void initialize(Workspace workspaceArg) {
            this.setLayout(new GridBagLayout());
            JScrollPane scrollPane = new JScrollPane(workspaceArg);
            this.add((Component)scrollPane, new GBC(0, 0).both());
            AskForParameterValuesActionFilter filter = new AskForParameterValuesActionFilter(workspaceArg);
            filter.attach();
        }
    }

    private abstract class AbstractFlowParametersPanel
    extends AbstractAlgorithmConfiguratorPanel.AbstractParametersPanel {
        protected AbstractFlowParametersPanel() throws ClientException {
            super(FlowAlgorithmConfiguratorPanel.this);
            final Window owner = FlowAlgorithmConfiguratorPanel.this.getOwner();
            RemoteTask<Graph> task = new RemoteTask<Graph>(){

                protected void performTask() throws Exception {
                    FlowAlgorithmConfigurator configurator = FlowAlgorithmConfiguratorPanel.this.getConfigurator();
                    Flow flow = configurator.getFlow();
                    Graph taskGraph = new Graph(owner, flow);
                    this.setResult(taskGraph);
                }
            };
            String prefix = "csbase.client.algorithms.view.flow.FlowAlgorithmConfiguratorPanel.";
            String taskTitle = LNG.get((String)"csbase.client.algorithms.view.flow.FlowAlgorithmConfiguratorPanel.reading_configurator_title");
            String taskMessage = LNG.get((String)"csbase.client.algorithms.view.flow.FlowAlgorithmConfiguratorPanel.reading_configurator");
            boolean successful = task.execute(owner, taskTitle, taskMessage);
            if (!successful) {
                throw new ClientException(task.getError());
            }
            FlowAlgorithmConfiguratorPanel.this.graph = (Graph)task.getResult();
            FlowAlgorithmConfiguratorPanel.this.workspace = new Workspace(FlowAlgorithmConfiguratorPanel.this.graph, false, true);
            this.createFilters(FlowAlgorithmConfiguratorPanel.this.workspace);
            this.initialize(FlowAlgorithmConfiguratorPanel.this.workspace);
        }

        @Override
        public boolean highlightValidationResult(ViewValidationResult result) {
            return FlowAlgorithmConfiguratorPanel.this.getGraph().highlightValidationResult(result);
        }

        @Override
        public ViewValidationResult validate(ValidationMode mode) {
            return FlowAlgorithmConfiguratorPanel.this.getGraph().validate(mode);
        }

        protected abstract void initialize(Workspace var1);

        private void createFilters(Workspace workspaceArg) {
            HighlightElementFilter highlightElementFilter = new HighlightElementFilter(workspaceArg);
            highlightElementFilter.attach();
            HintElementFilter hintElementFilter = new HintElementFilter(workspaceArg);
            hintElementFilter.attach();
        }
    }
}

