/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.remote.srvproxies.UserGroupProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.UserGroup;
import csbase.logic.UserGroupInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class UserGroupInfoDialog {
    protected DesktopComponentDialog window;
    protected Window owner;
    protected JTextField name;
    protected JTextField description;
    protected JButton modifyUserGroupButton;
    protected String windowLabel;
    protected UserGroup userGroup;
    protected boolean isNew;

    protected void display() {
        JPanel mainPane = new JPanel(new BorderLayout());
        String borderTitle = this.isNew ? LNG.get((String)"IAS_USERGROUP_REGISTRATION") : LNG.get((String)"IAS_USERGROUP_UPDATE_TITLE");
        mainPane.setBorder(BorderFactory.createTitledBorder(borderTitle));
        mainPane.add((Component)this.makeMainPanel(), "North");
        mainPane.add((Component)this.makeClearButtonPanel(), "South");
        JPanel backPane = new JPanel(new BorderLayout());
        backPane.add(mainPane);
        backPane.add((Component)this.makeButtonPanel(), "South");
        this.window = new DesktopComponentDialog(this.owner, this.windowLabel);
        this.window.getContentPane().add(backPane);
        this.window.setDefaultCloseOperation(2);
        this.window.pack();
        this.window.center(this.owner);
        this.window.setVisible(true);
    }

    protected JPanel makeMainPanel() {
        this.name = new JTextField(20);
        JLabel nameL = new JLabel(LNG.get((String)"IAS_USERGROUP"));
        this.description = new JTextField();
        JLabel descriptionL = new JLabel(LNG.get((String)"IAS_USERGROUP_DESCRIPTION"));
        this.initFields();
        GridLayout layout = new GridLayout(0, 1);
        layout.setVgap(10);
        JPanel labelsPanel = new JPanel(layout);
        labelsPanel.add(nameL);
        labelsPanel.add(descriptionL);
        JPanel fieldsPanel = new JPanel(new GridLayout(0, 1));
        fieldsPanel.add(this.name);
        fieldsPanel.add(this.description);
        JPanel panel = new JPanel();
        panel.add(labelsPanel);
        panel.add(fieldsPanel);
        return panel;
    }

    protected void initFields() {
        if (this.isNew) {
            return;
        }
        this.name.setText(this.userGroup.getName());
        this.description.setText(this.userGroup.getDesc());
        ChangeListener changeList = new ChangeListener();
        this.name.addKeyListener(changeList);
        this.description.addKeyListener(changeList);
    }

    private JPanel makeClearButtonPanel() {
        JPanel panel = new JPanel();
        panel.add(this.makeClearButton());
        return panel;
    }

    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        if (this.isNew) {
            buttonPanel.add(this.makeAddUserGroupButton());
            buttonPanel.add(this.makeCancelButton());
        } else {
            buttonPanel.add(this.makeChangeButton());
            buttonPanel.add(this.makeCloseButton());
        }
        return buttonPanel;
    }

    private JButton makeClearButton() {
        JButton clearButton = new JButton(LNG.get((String)"IAS_CLEAR"));
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                UserGroupInfoDialog.this.clearFields();
            }
        });
        return clearButton;
    }

    protected JButton makeAddUserGroupButton() {
        JButton addUserGroupButton = new JButton(LNG.get((String)"IAS_USERGROUP_INCLUDE"));
        addUserGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (UserGroupInfoDialog.this.validateFields()) {
                    UserGroupInfoDialog.this.createUserGroup();
                } else {
                    StandardErrorDialogs.showErrorDialog((Window)UserGroupInfoDialog.this.window, UserGroupInfoDialog.this.windowLabel, LNG.get((String)"IAS_FILL_ALL_FIELDS"));
                }
            }
        });
        return addUserGroupButton;
    }

    protected JButton makeChangeButton() {
        this.modifyUserGroupButton = new JButton(LNG.get((String)"IAS_USERGROUP_UPDATE"));
        this.modifyUserGroupButton.setEnabled(false);
        this.modifyUserGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (UserGroupInfoDialog.this.validateFields()) {
                    UserGroupInfoDialog.this.modifyUserGroup();
                    UserGroupInfoDialog.this.window.close();
                } else {
                    StandardErrorDialogs.showErrorDialog((Window)UserGroupInfoDialog.this.window, UserGroupInfoDialog.this.windowLabel, LNG.get((String)"IAS_FILL_ALL_FIELDS"));
                    UserGroupInfoDialog.this.modifyUserGroupButton.setEnabled(false);
                }
            }
        });
        return this.modifyUserGroupButton;
    }

    protected JButton makeCancelButton() {
        JButton cancelButton = new JButton(LNG.get((String)"IAS_CLOSE"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                UserGroupInfoDialog.this.window.close();
            }
        });
        return cancelButton;
    }

    protected JButton makeCloseButton() {
        JButton closeButton = new JButton(LNG.get((String)"IAS_CLOSE"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int selected;
                Object[] options;
                if (UserGroupInfoDialog.this.hasChanged() && !UserGroupInfoDialog.this.isEmpty() && (options = new Object[]{LNG.get((String)"IAS_UPDATE"), LNG.get((String)"IAS_CANCEL")})[selected = JOptionPane.showOptionDialog(UserGroupInfoDialog.this.window, LNG.get((String)"IAS_USERGROUP_UPDATE_CONFIRMATION"), UserGroupInfoDialog.this.windowLabel, -1, 1, null, options, options[0])] == LNG.get((String)"IAS_UPDATE") && UserGroupInfoDialog.this.validateFields()) {
                    UserGroupInfoDialog.this.modifyUserGroup();
                }
                UserGroupInfoDialog.this.window.close();
            }
        });
        return closeButton;
    }

    protected boolean validateFields() {
        return !this.name.getText().trim().equals("");
    }

    protected void clearFields() {
        this.name.setText("");
        this.description.setText("");
        this.name.requestFocus();
    }

    public boolean hasChanged() {
        return !this.name.getText().trim().equals(this.userGroup.getName()) || !this.description.getText().trim().equals(this.userGroup.getDesc());
    }

    private boolean isEmpty() {
        return this.name.getText().trim().equals("") && this.description.getText().trim().equals("");
    }

    public void createUserGroup() {
        String nameText = this.name.getText().trim();
        String descriptionText = this.description.getText().trim();
        UserGroupInfo userGroupInfo = new UserGroupInfo(nameText, descriptionText);
        this.userGroup = UserGroupProxy.createUserGroup(this.window, this.windowLabel, LNG.get((String)"IAS_WAITING_USERGROUP_CREATION"), userGroupInfo);
        if (this.userGroup != null) {
            StandardDialogs.showInfoDialog((Component)this.window, (String)this.windowLabel, (Object)MessageFormat.format(LNG.get((String)"IAS_USERGROUP_INCLUDED_WITH_SUCCESS"), this.userGroup.getName()));
            this.userGroup = null;
            this.clearFields();
        }
    }

    public void modifyUserGroup() {
        String nameText = this.name.getText().trim();
        String descText = this.description.getText().trim();
        UserGroupInfo userGroupInfo = new UserGroupInfo(nameText, descText);
        UserGroup modifiedUserGroup = UserGroupProxy.modifyUserGroup(this.window, this.windowLabel, LNG.get((String)"IAS_WAITING_USERGROUP_MODIFICATION"), this.userGroup.getId(), userGroupInfo);
        if (modifiedUserGroup != null) {
            this.userGroup = modifiedUserGroup;
            StandardDialogs.showInfoDialog((Component)this.window, (String)this.windowLabel, (Object)MessageFormat.format(LNG.get((String)"IAS_USERGROUP_MODIFIED_WITH_SUCCESS"), this.userGroup.getName()));
            this.modifyUserGroupButton.setEnabled(false);
        }
    }

    public UserGroupInfoDialog(Window owner) {
        this(owner, null);
    }

    public UserGroupInfoDialog(Window owner, UserGroup userGroup) {
        this.owner = owner;
        if (userGroup == null) {
            this.windowLabel = LNG.get((String)"IAS_USERGROUP_INCLUSION_TITLE");
            this.isNew = true;
        } else {
            this.windowLabel = LNG.get((String)"IAS_USERGROUP_UPDATE_TITLE");
            this.isNew = false;
            this.userGroup = userGroup;
        }
        this.display();
    }

    private class ChangeListener
    extends KeyAdapter {
        private ChangeListener() {
        }

        @Override
        public void keyReleased(KeyEvent kev) {
            if (UserGroupInfoDialog.this.hasChanged()) {
                UserGroupInfoDialog.this.modifyUserGroupButton.setEnabled(true);
            } else {
                UserGroupInfoDialog.this.modifyUserGroupButton.setEnabled(false);
            }
        }
    }
}

