package csbase.client.algorithms.parameters;

/**
 * O Modelo do {@link NumberTextField Campo de Texto}.
 *
 * @param <N> O tipo do nmero.
 *
 * @author lmoreira
 */
public interface NumberTextFieldModel<N extends Number> {
  /**
   * Adiciona um observador.
   *
   * @param listener O observador (No aceita {@code null}).
   */
  void addNumberTextFieldModelListener(NumberTextFieldModelListener listener);

  /**
   * Obtm o valor.
   *
   * @return O valor (Pode ser {@code null}).
   */
  N getValue();

  /**
   * Remove o observador.
   *
   * @param listener O observador (No aceita {@code null}).
   *
   * @return {@code true} em caso de sucesso ou {@code false} se o observador
   *         no estiver cadastradado.
   */
  boolean removeNumberTextFieldListener(NumberTextFieldModelListener listener);

  /**
   * Atribui um valor para este modelo.
   *
   * @param number O nmero (Aceita {@code null}).
   */
  void setValue(N number);

  /**
   * Obtm o valor de sinalizao de erro.
   *
   * @return o valor.
   */
  N getErrorValue();
}
