package csbase.client.csdk;

import java.util.Map;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.csdk.v2.CSDKv2ContextFactory;
import csbase.logic.applicationservice.ApplicationRegistry;


/**
 * Fbrica padro de contextos para o CSDK 1.0.
 */
public class DefaultCSDKContextFactory implements ICSDKContextFactory {

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<Class<? extends csdk.v1_0.api.core.IContext>, csdk.v1_0.api.core
    .IContext> createCSDKContexts(
    String instanceId,
    Class<? extends csdk.v1_0.api.application.IApplication> mainClass,
    ApplicationRegistry registry) throws ApplicationException {
    return csbase.client.csdk.v1_0.CSDKContextFactory
      .createCSDKContexts(instanceId, mainClass, registry);
  }

  @Override
  public Map<Class<? extends csdk.v2.api.core.IContext>, csdk.v2.api.core
    .IContext> createCSDKv2Contexts(
    String instanceId,
    Class<? extends csdk.v2.api.application.IApplication> mainClass,
    ApplicationRegistry registry) throws ApplicationException {
    return CSDKv2ContextFactory
      .createCSDKContexts(instanceId, mainClass, registry);
  }
}
