/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.rest;

import csbase.client.Client;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.NotificationPanel;
import csbase.client.desktop.RemoteTask;
import csbase.client.login.LoginInterface;
import csbase.client.login.PreLogin;
import csbase.client.rest.AuthFilter;
import csbase.client.rest.DebugMapper;
import csbase.logic.SecureKey;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.RestServiceInterface;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import io.swagger.jersey.listing.ApiListingResourceJSON;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.rmi.RemoteException;
import java.security.DigestException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import tecgraf.javautils.core.lng.LNG;

public class RestController {
    private static RestController instance;
    private ResourceConfig resourceConfig;
    private HttpServer httpServer;
    private Container container;
    private String token;
    private final LoginInterface userLogin = Client.getInstance().getLoginObject();
    private boolean developMode = false;
    private final List<String> resourcePackages = new ArrayList<String>();
    private final Map<String, List<Object>> appResources;
    private String docFrontEndDirectory;
    private BeanConfig beanConfig;
    private int httpPort;
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 15000;

    public void setDocFrontEndDirectory(String docFrontEndDirectory) {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            throw new IllegalStateException("Server is already started");
        }
        this.docFrontEndDirectory = docFrontEndDirectory;
    }

    public static RestController getInstance() {
        if (instance == null) {
            instance = new RestController();
        }
        return instance;
    }

    private static int getAvailablePort() {
        int port;
        block11: {
            ServerSocket socket = null;
            port = -1;
            try {
                socket = new ServerSocket(0);
                port = socket.getLocalPort();
            }
            catch (IOException e) {
                if (socket == null) break block11;
                try {
                    socket.close();
                }
                catch (IOException e2) {
                    throw new RuntimeException("You should handle this error.", e2);
                }
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("You should handle this error.", e);
                    }
                }
            }
        }
        return port;
    }

    private RestController() {
        this.resourcePackages.add("csbase.client.rest.resources");
        this.appResources = new HashMap<String, List<Object>>();
        this.docFrontEndDirectory = "csbase/client/rest/swagger-ui/";
        if (this.userLogin instanceof PreLogin) {
            this.token = ((PreLogin)this.userLogin).getClientInstanceId();
            if (this.token.startsWith("TOKENID:")) {
                this.token = this.token.substring("TOKENID:".length());
            }
        } else {
            SecureKey sessionKey = new SecureKey();
            try {
                this.token = sessionKey.digest();
            }
            catch (DigestException e) {
                e.printStackTrace();
                this.token = this.userLogin.getClientInstanceId();
            }
        }
    }

    public String getAuthToken() {
        return this.token;
    }

    public boolean isDeveloperMode() {
        return this.developMode;
    }

    public boolean isTokenAuthorized(String checkToken) {
        return this.isDeveloperMode() || this.token.equals(checkToken);
    }

    public LoginInterface getUserLogin() {
        return this.userLogin;
    }

    public void stopServer() {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            this.httpServer.shutdownNow();
            RemoteTask<Void> task = new RemoteTask<Void>(){

                protected void performTask() throws Exception {
                    ClientRemoteLocator.restService.unregisterClientHttpServer(RestController.this.token);
                }
            };
            String msg = LNG.get((String)"csbase.client.rest.server.unregistering");
            task.execute(DesktopFrame.getInstance().getDesktopFrame(), null, msg);
            if (task.getError() != null) {
                task.getError().printStackTrace();
            }
        }
    }

    public void startServer() {
        try {
            this.startServer(DEFAULT_HOST, 15000);
        }
        catch (ProcessingException ex) {
            this.startServer(DEFAULT_HOST, RestController.getAvailablePort());
        }
    }

    public void startServer(int port) {
        this.startServer(DEFAULT_HOST, port);
    }

    public void startServer(String host, int port) {
        this.httpPort = port;
        this.beanConfig = new BeanConfig();
        this.beanConfig.setVersion("1.0");
        this.beanConfig.setDescription(LNG.get((String)"csbase.client.rest.server.description"));
        this.beanConfig.setBasePath("/");
        this.beanConfig.setResourcePackage(String.join((CharSequence)",", this.resourcePackages));
        this.beanConfig.setScan(true);
        this.resourceConfig = this.buildResourceConfig();
        this.resourceConfig.registerInstances(new Object[]{new ContainerLifecycleListener(){

            public void onStartup(Container container) {
                RestController.this.container = container;
                System.out.println("Container recuperado");
            }

            public void onReload(Container container) {
                System.out.println("RELOADED");
            }

            public void onShutdown(Container container) {
            }
        }});
        final String baseURL = "http://" + host + ":" + port + "/";
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)URI.create(baseURL), (ResourceConfig)this.resourceConfig);
        CLStaticHttpHandler staticHttpHandler = new CLStaticHttpHandler(RestController.class.getClassLoader(), new String[]{this.docFrontEndDirectory});
        this.httpServer.getServerConfiguration().addHttpHandler((HttpHandler)staticHttpHandler, new String[]{"/docs/"});
        NotificationPanel notificationPanel = DesktopFrame.getInstance().getNotificationPanel();
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                RestServiceInterface restService = ClientRemoteLocator.restService;
                restService.registerClientHttpServer(RestController.this.token, baseURL);
                boolean devMode = restService.isClientDeveloperMode();
                this.setResult(devMode);
            }
        };
        String taskMsg = LNG.get((String)"csbase.client.rest.server.registering");
        task.execute(DesktopFrame.getInstance().getDesktopFrame(), null, taskMsg);
        Exception error = task.getError();
        if (error == null) {
            this.developMode = (Boolean)task.getResult();
        } else {
            String errorMsg = LNG.get((String)"csbase.client.rest.server.start.error") + " - " + error.getLocalizedMessage();
            notificationPanel.addNotificationLine(notificationPanel.makeNotificationLine(new Date(), "ClientRestService", errorMsg, true));
        }
        String logMsg = LNG.get((String)"csbase.client.rest.server.started") + " - " + port + (this.isDeveloperMode() ? " (dev mode)" : "");
        notificationPanel.addNotificationLine(notificationPanel.makeNotificationLine(new Date(), "ClientRestService", logMsg, true));
        String apiMsg = LNG.get((String)"csbase.client.rest.server.doc.notification") + " " + baseURL + "docs/";
        notificationPanel.addNotificationLine(notificationPanel.makeNotificationLine(new Date(), "ClientRestService", apiMsg, true));
        this.logMessage("RestService", "Sevidor iniciado na porta " + port);
    }

    public void registerService(Class<?>[] classes) {
        this.resourceConfig.registerClasses((Class[])classes);
    }

    public void addResourcePackages(String ... packages) {
        this.resourcePackages.addAll(Arrays.asList(packages));
        this.beanConfig.setResourcePackage(String.join((CharSequence)",", this.resourcePackages));
        this.beanConfig.setScan();
        if (this.container != null) {
            this.resourceConfig = this.buildResourceConfig();
            this.container.reload(this.resourceConfig);
        }
    }

    public void addApplicationResources(String appId, List<Object> resources) {
        this.appResources.put(appId, resources);
        if (this.container != null) {
            this.resourceConfig = this.buildResourceConfig();
            this.container.reload(this.resourceConfig);
        }
    }

    public void removeApplicationResources(String appId) {
        this.appResources.remove(appId);
        if (this.container != null) {
            this.resourceConfig = this.buildResourceConfig();
            this.container.reload(this.resourceConfig);
        }
    }

    public int getPort() {
        if (this.httpServer == null || !this.httpServer.isStarted()) {
            return -999;
        }
        return this.httpPort;
    }

    public void registerPackages(String ... packages) {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            this.httpServer.shutdownNow();
        }
        this.resourcePackages.addAll(Arrays.asList(packages));
        this.startServer();
    }

    private void logMessage(String type, String msg) {
        try {
            ClientRemoteLocator.eventLogService.addClientInformation(new String[]{"ClientRest"}, new String[]{type, msg});
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private ResourceConfig buildResourceConfig() {
        ResourceConfig rc = new ResourceConfig();
        rc.packages(true, this.resourcePackages.toArray(new String[this.resourcePackages.size()]));
        this.appResources.entrySet().stream().forEach(e -> rc.registerInstances(((List)e.getValue()).toArray()));
        rc.register(JacksonFeature.class);
        rc.register(AuthFilter.class);
        rc.register(DebugMapper.class);
        rc.register(ApiListingResourceJSON.class);
        rc.register(ApiListingResource.class);
        rc.register(SwaggerSerializers.class);
        return rc;
    }
}

