/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.dal.xml.elements;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;

import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLElementInterface;
import tecgraf.javautils.xml.XMLRootElement;
import csbase.client.applications.commandsmonitor.dal.xml.XmlConfigDAO;
import csbase.client.applications.commandsmonitor.models.ColumnDTO;
import csbase.client.applications.commandsmonitor.models.CommandsFilterDTO;
import csbase.client.applications.commandsmonitor.models.CommandsTableDTO;
import csbase.client.applications.commandsmonitor.models.TabbedPaneDTO;

/**
 * Elemento de configurao.
 * 
 * @author Tecgraf
 */
public class ConfigElement extends XMLRootElement {

  /**
   * Consulta o nome da tag
   * 
   * @return tag
   */
  public static final String getTagName() {
    return "config";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void endTag(List<XMLElementInterface> childrenList) {

    XmlConfigDAO datasource = (XmlConfigDAO) getAppContextObject();

    ImprovedXMLListIterator iterator =
      new ImprovedXMLListIterator(childrenList);

    XMLElementInterface columnsElement =
      iterator.next(ColumnsSetElement.getTagName());
    if (null != columnsElement) {
      Set<ColumnDTO> columns = (Set<ColumnDTO>) columnsElement.getAppObject();

      datasource.setColumnsInfo(columns);
    }

    iterator.reset();

    XMLElementInterface filtersElement =
      iterator.next(FiltersSetElement.getTagName());
    if (null != filtersElement) {
      Set<CommandsFilterDTO> filters =
        (Set<CommandsFilterDTO>) filtersElement.getAppObject();

      datasource.setFiltersInfo(filters);
    }

    iterator.reset();

    XMLElementInterface tablesElement =
      iterator.next(TablesSetElement.getTagName());
    if (null != tablesElement) {
      Set<CommandsTableDTO> tablesInfos =
        (Set<CommandsTableDTO>) tablesElement.getAppObject();

      datasource.setTablesInfo(tablesInfos);
    }

    iterator.reset();

    XMLElementInterface tabsElement =
      iterator.next(TabbedPaneElement.getTagName());
    if (null != tabsElement) {
      TabbedPaneDTO tabs = (TabbedPaneDTO) tabsElement.getAppObject();
      datasource.setTabsConfig(tabs);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(Writer writer, String ident) throws IOException {
    throw new IllegalAccessError("Esse mtodo no deve ser utilizado.");
  }
}
