package csbase.client.applications.projectsmanager.proxy;

import java.rmi.RemoteException;
import java.util.List;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlockType;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectPermissions.SharingType;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;

/**
 * Ao que altera o status de compartilhamento de projetos.
 * 
 * @author jnlopes
 * 
 */
public class SetProjectSharingStatsTask extends ProjectsManagerTask<Boolean> {

  /**
   * Informaes dos projetos.
   */
  private List<ProjectsManagerData> projects;

  /**
   * Escopo para o qual os projetos sero alterados.
   */
  private ProjectsManagerScope scope;

  /**
   * Tipo de compartilhamento.
   */
  private SharingType accessType;

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   * @param projects Informaes dos projetos.
   * @param scope Escopo para o qual os projetos sero alterados.
   * @param accessType tipo do compartilhamento
   */
  public SetProjectSharingStatsTask(ProjectsManager projectsManager,
    List<ProjectsManagerData> projects, ProjectsManagerScope scope,
    SharingType accessType) {
    super(projectsManager);
    this.projects = projects;
    this.scope = scope;
    this.accessType = accessType;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws RemoteException {
    ProjectServiceInterface psi = ClientRemoteLocator.projectService;
    if (scope == ProjectsManagerScope.PRIVATE) {
      for (ProjectsManagerData prj : projects) {
        CommonClientProject ccp = psi.openProject(prj.getProjectId(), false);
        if (ccp == null) {
          setResult(false);
          return;
        }
        ccp.makePrivate();
        /*
         * Tratamento de adio de mensagens no histrico.
         */
        ProjectsManagerUI.addAutomaticHistoryBlock(ccp,
          ProjectHistoryBlockType.PROJECT_PRIVATE);
        ccp.close(true);
      }
    }
    else if (scope == ProjectsManagerScope.PUBLIC) {
      for (ProjectsManagerData prj : projects) {
        CommonClientProject ccp = psi.openProject(prj.getProjectId(), false);
        if (ccp == null) {
          continue;
        }
        ccp.makePublic(accessType == SharingType.ALL_RO);
        /*
         * Tratamento de adio de mensagens no histrico.
         */
        ProjectsManagerUI.addAutomaticHistoryBlock(ccp,
          ProjectHistoryBlockType.PROJECT_PUBLIC);
        ccp.close(true);
      }
    }
    setResult(true);
  }
}
