package csbase.client.csdk.v2;

import java.util.HashMap;
import java.util.Map;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.csdk.v2.application.CSDKApplicationContext;
import csbase.client.csdk.v2.command.CSDKCommandContext;
import csbase.client.csdk.v2.eventlog.CSDKEventLogContext;
import csbase.client.csdk.v2.extras.openbus.CSDKOpenBusContext;
import csbase.client.csdk.v2.extras.rest.CSDKRestContext;
import csbase.client.csdk.v2.extras.user.CSDKUserContext;
import csbase.client.csdk.v2.filesystem.CSDKLocalFileSystemContext;
import csbase.client.csdk.v2.filesystem.CSDKProjectContext;
import csbase.logic.applicationservice.ApplicationRegistry;
import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.command.ICommandContext;
import csdk.v2.api.core.IContext;
import csdk.v2.api.filesystem.local.ILocalFileSystemContext;
import csdk.v2.api.filesystem.project.IProjectContext;
import csdk.v2.api.user.IUserContext;
import csdk.v2.extras.context.IEventLogContext;
import csdk.v2.extras.context.IOpenBusContext;
import csdk.v2.extras.context.rest.IRestContext;

/**
 * Interface para fbricas de contextos do CSDK 2.0
 */
public class CSDKv2ContextFactory {

  /**
   * Cria o mapa de contextos do CSDK, que sero disponibilizados para a
   * aplicao especificada atravs do ambiente CSDK
   * {@link csdk.v2.api.core.ICSDKEnvironment#getContext(Class)}, indexados
   * pelas interfaces CSDK que eles implementam.
   *
   * @param instanceId identificador da instncia da aplicao.
   * @param mainClass classe principal da aplicao.
   * @param registry o registro da aplicao.
   * @return o mapa de contextos.
   * @throws ApplicationException em caso de erro ao criar os contextos.
   */
  public static Map<Class<? extends IContext>, IContext> createCSDKContexts(
    String instanceId,
    Class<? extends csdk.v2.api.application.IApplication> mainClass,
    ApplicationRegistry registry) throws ApplicationException {
    Map<Class<? extends IContext>, IContext> contexts = new HashMap<>();
    contexts.put(IApplicationContext.class,
      new CSDKApplicationContext(instanceId, mainClass, registry));
    contexts.put(IProjectContext.class, new CSDKProjectContext(registry));
    contexts.put(ILocalFileSystemContext.class,
      new CSDKLocalFileSystemContext(registry));
    contexts.put(ICommandContext.class, new CSDKCommandContext());
    contexts.put(IOpenBusContext.class, new CSDKOpenBusContext());
    contexts.put(IUserContext.class, new CSDKUserContext());
    contexts.put(IEventLogContext.class, new CSDKEventLogContext());
    contexts.put(IRestContext.class, new CSDKRestContext(instanceId));
    return contexts;
  }
}
