/*
 * $Id: ApplicationImages.java 175848 2016-09-13 18:54:42Z tatimf $
 */

package csbase.client.applications;

import java.net.URL;

import javax.swing.ImageIcon;

/**
 * Clase esttica que possui todos os cones padro para serem usados nas
 * aplicaes baseadas em CSBASE.  responsvel pela montagem de uma imagem do
 * resource de uma aplicao com base na biblioteca comum do CSBASE localizada
 * em <code>"/csbase/client/resources/applicationimages/"</code>. O uso destas
 * imagens fica a crtrio do desenvolvedor e do sistema. Porm, o layout e a
 * semntica de cada imagem devem ser alterados em conformidade com o grupo de
 * interface grfica, pois <u>todos</u> os sistemas CSBASE-like sero afetados!
 *
 * @author Tecgraf/PUC-Rio
 * @see "ltima modificao feita por: $author$"
 */
public class ApplicationImages {
  /**
   * <img style="text-align:right;" src="../../../Algorithm16.gif" alt= "">
   * Imagem 16x16 para representar um algoritmo.
   */
  public static final ImageIcon ICON_ALGORITHM_16 = createImageIcon(
    "Algorithm16");

  /**
   * <img style="text-align:right;" src="../../../Parameter16.gif" alt= "">
   * Imagem 16x16 para representar um algoritmo.
   */
  public static final ImageIcon ICON_PARAMETER_16 = createImageIcon(
    "Parameter16");

  /**
   * <img style="text-align:right;" src="../../../Mandatory7.gif" alt=""> Imagem
   * 7x16 para representar um campo mandatrio.
   */
  public static final ImageIcon ICON_MANDATORY_7 = createImageIcon(
    "Mandatory7");

  /**
   * <img style="text-align:right;" src="../../../FlowConnection16.gif" alt="">
   * Imagem 16x16 para representar um algoritmo.
   */
  public static final ImageIcon ICON_FLOW_CONNECTION_16 = createImageIcon(
    "FlowConnection16");

  /**
   * <img style="text-align:right;" src="../../../FlowNode16.gif" alt=""> Imagem
   * 16x16 para representar um algoritmo.
   */
  public static final ImageIcon ICON_FLOW_NODE_16 = createImageIcon(
    "FlowNode16");

  /**
   * <img style="text-align:right;" src="../../../AlgorithmMng16.gif" alt="">
   * Imagem 16x16 para representar o gerenciamento de algoritmos (EM TESTE).
   */
  public static final ImageIcon ICON_ALGORITHM_MNG_16 = createImageIcon(
    "AlgorithmMng16");

  /**
   * <img style="text-align:right;" src="../../../AlgorithmCategory16.gif" alt=
   * ""> Imagem 16x16 para representar uma categoria de algoritmos (EM TESTE).
   */
  public static final ImageIcon ICON_ALGORITHM_CATEGORY_16 = createImageIcon(
    "AlgorithmCategory16");

  /**
   * <img style="text-align:right;" src="../../../EditParams16.gif" alt="">
   * Imagem 16x16 para toolbar do construtor de fluxo (editar parmetros)
   */
  public static final ImageIcon ICON_EDITPARAMS_16 = createImageIcon(
    "EditParams16");

  /**
   * <img style="text-align:right;" src="../../../ViewParams16.gif" alt="">
   * Imagem 16x16 para toolbar do construtor de fluxo (visualizar parmetros)
   */
  public static final ImageIcon ICON_VIEWPARAMS_16 = createImageIcon(
    "ViewParams16");

  /**
   * <img style="text-align:right;" src="../../../AnimatedEngines32.gif" alt="">
   * Imagem animada 32x32 indicativa de processo em andamento
   */
  public static final ImageIcon ICON_ANIMATEDENGINES_32 = createImageIcon(
    "AnimatedEngines32");

  /**
   * <img style="text-align:right;" src="../../../MoveAllUp10.gif" alt="">
   * Imagem 10x10 de movimentao de layers: subir ao topo (primeiro).
   */
  public static final ImageIcon ICON_MOVEALLUP_10 = createImageIcon(
    "MoveAllUp10");

  /**
   * <img style="text-align:right;" src="../../../MoveAllDown10.gif" alt="">
   * Imagem 10x10 de movimentao de layers: descer  base (ltimo).
   */
  public static final ImageIcon ICON_MOVEALLDOWN_10 = createImageIcon(
    "MoveAllDown10");

  /**
   * <img style="text-align:right;" src="../../../MoveDown10.gif" alt=""> Imagem
   * 10x10 de movimentao de layers: descer.
   */
  public static final ImageIcon ICON_MOVEDOWN_10 = createImageIcon(
    "MoveDown10");

  /**
   * <img style="text-align:right;" src="../../../MoveUp10.gif" alt=""> Imagem
   * 10x10 de movimentao de layers: subir.
   */
  public static final ImageIcon ICON_MOVEUP_10 = createImageIcon("MoveUp10");

  /**
   * <img style="text-align:right;" src="../../../SortingUp4.gif" alt=""> Imagem
   * 7x4 de ordenao de tabelas: ascendente.
   */
  public static final ImageIcon ICON_SORTINGUP_4 = createImageIcon(
    "SortingUp4");

  /**
   * <img style="text-align:right;" src="../../../SortingDown4.gif" alt="">
   * Imagem 7x4 de ordenao de tabelas: descendente.
   */
  public static final ImageIcon ICON_SORTINGDOWN_4 = createImageIcon(
    "SortingDown4");

  /**
   * <img style="text-align:right;" src="../../../SelectRemove10.gif" alt="">
   * Imagem 10x10 para elementos de listas de seleo: remover.
   */
  public static final ImageIcon ICON_SELECTREMOVE_10 = createImageIcon(
    "SelectRemove10");

  /**
   * <img style="text-align:right;" src="../../../SelectAddAll10.gif" alt="">
   * Imagem 10x10 para elementos de listas de seleo: adicionar todos.
   */
  public static final ImageIcon ICON_SELECTADDALL_10 = createImageIcon(
    "SelectAddAll10");

  /**
   * <img style="text-align:right;" src="../../../SelectAdd10.gif" alt="">
   * Imagem 10x10 para elementos de listas de seleo: adicionar.
   */
  public static final ImageIcon ICON_SELECTADD_10 = createImageIcon(
    "SelectAdd10");

  /**
   * <img style="text-align:right;" src="../../../SelectRemoveAll10.gif" alt="">
   * Imagem 10x10 para elementos de listas de seleo: remover todos.
   */
  public static final ImageIcon ICON_SELECTREMOVEALL_10 = createImageIcon(
    "SelectRemoveAll10");

  /**
   * <img style="text-align:right;" src="../../../WinCascade16.gif" alt="">
   * Imagem 16x16 para toolbar de manipulao de janelas: cascatear.
   */
  public static final ImageIcon ICON_WINCASCADE_16 = createImageIcon(
    "WinCascade16");

  /**
   * <img style="text-align:right;" src="../../../WinTileHorizontal16.gif" alt=
   * ""> Imagem 16x16 para toolbar de manipulao de janelas: ladrilhar (hor)
   */
  public static final ImageIcon ICON_WINTILEHORIZONTAL_16 = createImageIcon(
    "WinTileHorizontal16");

  /**
   * Imagem 16x16 para simbolizar ocultar janela.
   */
  public static final ImageIcon ICON_HIDEWINDOW_16 = createImageIcon(
    "HideWindow16");

  /**
   * <img style="text-align:right;" src="../../../WinTileVertical16.gif" alt="">
   * Imagem 16x16 para toolbar de manipulao de janelas: ladrilhar (ver).
   */
  public static final ImageIcon ICON_WINTILEVERTICAL_16 = createImageIcon(
    "WinTileVertical16");

  /**
   * <img style="text-align:right;" src="../../../SendMail16.gif" alt="">
   * cone-padro 16x16 de uso geral: envio de e-mail
   */
  public static final ImageIcon ICON_SENDMAIL_16 = createImageIcon(
    "SendMail16");

  /**
   * <img style="text-align:right;" src="../../../SendMail24.gif" alt="">
   * cone-padro 24x24 de uso geral: envio de e-mail
   */
  public static final ImageIcon ICON_SENDMAIL_24 = createImageIcon(
    "SendMail24");

  /**
   * <img style="text-align:right;" src="../../../Blank16.gif" alt="">
   * cone-padro (especial) 16x16 de uso geral: totalmente transparente
   */
  public static final ImageIcon ICON_BLANK_16 = createImageIcon("Blank16");

  /**
   * <img style="text-align:right;" src="../../../Blank24.gif" alt="">
   * cone-padro (especial) 24x24 de uso geral: totalmente transparente
   */
  public static final ImageIcon ICON_BLANK_24 = createImageIcon("Blank24");

  /**
   * <img style="text-align:right;" src="../../../XWindows16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_XWINDOWS_16 = createImageIcon(
    "XWindows16");

  /**
   * <img style="text-align:right;" src="../../../XWindows24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_XWINDOWS_24 = createImageIcon(
    "XWindows24");

  /**
   * <img style="text-align:right;" src="../../../Remove16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_REMOVE_16 = createImageIcon("Remove16");

  /**
   * <img style="text-align:right;" src="../../../Remove24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_REMOVE_24 = createImageIcon("Remove24");

  /**
   * <img style="text-align:right;" src="../../../Folder16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_FOLDER_16 = createImageIcon("Folder16");

  /**
   * <img style="text-align:right;" src="../../../Folder24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_FOLDER_24 = createImageIcon("Folder24");

  /**
   * <img style="text-align:right;" src="../../../FolderCut16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_FOLDERCUT_16 = createImageIcon(
    "FolderCut16");

  /**
   * <img style="text-align:right;" src="../../../FolderCut24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_FOLDERCUT_24 = createImageIcon(
    "FolderCut24");

  /**
   * <img style="text-align:right;" src="../../../SimpleFolderLocked16.gif" alt=
   * ""> cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_SIMPLE_FOLDER_LOCKED_16 = createImageIcon(
    "SimpleFolderLocked16");

  /**
   * <img style="text-align:right;" src="../../../SimpleFolderHidden16.gif" alt=
   * ""> cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_SIMPLE_FOLDER_HIDDEN_16 = createImageIcon(
    "SimpleFolderHidden16");

  /**
   * <img style="text-align:right;" src="../../../SimpleFolder16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_SIMPLE_FOLDER_16 = createImageIcon(
    "SimpleFolder16");

  /**
   * <img style="text-align:right;" src="../../../File16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_FILE_16 = createImageIcon("File16");

  /**
   * <img style="text-align:right;" src="../../../File16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_FILE_LOCAL_16 = createImageIcon(
    "FileLocal16");

  /**
   * <img style="text-align:right;" src="../../../File16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_FILE_PROJECT_16 = createImageIcon(
    "FileProject16");

  /**
   * <img style="text-align:right;" src="../../../File24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_FILE_24 = createImageIcon("File24");

  /**
   * <img style="text-align:right;" src="../../../FolderOutOfDate16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_FOLDEROUTOFDATE_16 = createImageIcon(
    "FolderOutOfDate16");

  /**
   * <img style="text-align:right;" src="../../../FolderOutOfDate24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_FOLDEROUTOFDATE_24 = createImageIcon(
    "FolderOutOfDate24");

  /**
   * <img style="text-align:right;" src="../../../Run16.gif" alt="">
   * cone-padro 16x16 de uso geral: execuo.
   */
  public static final ImageIcon ICON_RUN_16 = createImageIcon("Run16");

  /**
   * <img style="text-align:right;" src="../../../Flow16.gif" alt="">
   * cone-padro 16x16 de uso geral: fluxos.
   */
  public static final ImageIcon ICON_FLOW_16 = createImageIcon("Flow16");

  /**
   * <img style="text-align:right;" src="../../../Run24.gif" alt="">
   * cone-padro 24x24 de uso geral: execuo.
   */
  public static final ImageIcon ICON_RUN_24 = createImageIcon("Run24");

  /**
   * <img style="text-align:right;" src="../../../Fit16.gif" alt="">
   * cone-padro 16x16 de uso geral: enquadramento
   */
  public static final ImageIcon ICON_FIT_16 = createImageIcon("Fit16");

  /**
   * <img style="text-align:right;" src="../../../Fit24.gif" alt="">
   * cone-padro 24x24 de uso geral: enquadramento
   */
  public static final ImageIcon ICON_FIT_24 = createImageIcon("Fit24");

  /**
   * <img style="text-align:right;" src="../../../Down16.gif" alt="">
   * cone-padro 16x16 de uso geral: seta para baixo.
   */
  public static final ImageIcon ICON_DOWN_16 = createImageIcon("Down16");

  /**
   * <img style="text-align:right;" src="../../../Down24.gif" alt="">
   * cone-padro 24x24 de uso geral: seta para baixo.
   */
  public static final ImageIcon ICON_DOWN_24 = createImageIcon("Down24");

  /**
   * <img style="text-align:right;" src="../../../Up16.gif" alt=""> cone-padro
   * 16x16 de uso geral: seta para cima.
   */
  public static final ImageIcon ICON_UP_16 = createImageIcon("Up16");

  /**
   * <img style="text-align:right;" src="../../../Up24.gif" alt=""> cone-padro
   * 24x24 de uso geral: seta para cima.
   */
  public static final ImageIcon ICON_UP_24 = createImageIcon("Up24");

  /**
   * <img style="text-align:right;" src="../../../Left16.gif" alt="">
   * cone-padro 16x16 de uso geral: seta  esquerda.
   */
  public static final ImageIcon ICON_LEFT_16 = createImageIcon("Left16");

  /**
   * <img style="text-align:right;" src="../../../Left24.gif" alt="">
   * cone-padro 24x24 de uso geral: seta  esquerda.
   */
  public static final ImageIcon ICON_LEFT_24 = createImageIcon("Left24");

  /**
   * <img style="text-align:right;" src="../../../Right16.gif" alt="">
   * cone-padro 16x16 de uso geral: seta  direita.
   */
  public static final ImageIcon ICON_RIGHT_16 = createImageIcon("Right16");

  /**
   * <img style="text-align:right;" src="../../../Right16.gif" alt="">
   * cone-padro 24x24 de uso geral: seta  direita.
   */
  public static final ImageIcon ICON_RIGHT_24 = createImageIcon("Right24");

  /**
   * <img style="text-align:right;" src="../../../Users16.gif" alt="">
   * cone-padro 16x16 de uso geral: usurios.
   */
  public static final ImageIcon ICON_USERS_16 = createImageIcon("Users16");

  /**
   * <img style="text-align:right;" src="../../../Users24.gif" alt="">
   * cone-padro 24x24 de uso geral: usurios.
   */
  public static final ImageIcon ICON_USERS_24 = createImageIcon("Users24");

  /**
   * <img style="text-align:right;" src="../../../Share16.gif" alt="">
   * cone-padro 16x16 de uso geral: compartilhamento de dados.
   */
  public static final ImageIcon ICON_SHARE_16 = createImageIcon("Share16");

  /**
   * <img style="text-align:right;" src="../../../Share24.gif" alt="">
   * cone-padro 24x24 de uso geral: compartilhamento de dados.
   */
  public static final ImageIcon ICON_SHARE_24 = createImageIcon("Share24");

  /**
   * <img style="text-align:right;" src="../../../PageDec16.gif" alt="">
   * cone-padro 16x16 de uso geral: paginao. Ir para a pgina anterior.
   */
  public static final ImageIcon ICON_PAGE_DEC_16 = createImageIcon("PageDec16");

  /**
   * <img style="text-align:right;" src="../../../PageFirst16.gif" alt="">
   * cone-padro 16x16 de uso geral: paginao. Ir para a primeira pgina.
   */
  public static final ImageIcon ICON_PAGE_FIRST_16 = createImageIcon(
    "PageFirst16");

  /**
   * <img style="text-align:right;" src="../../../PageInc16.gif" alt="">
   * cone-padro 16x16 de uso geral: paginao. Ir para a prxima pgina.
   */
  public static final ImageIcon ICON_PAGE_INC_16 = createImageIcon("PageInc16");

  /**
   * <img style="text-align:right;" src="../../../PageLast16.gif" alt="">
   * cone-padro 16x16 de uso geral: paginao. Ir para a ltima pgina.
   */
  public static final ImageIcon ICON_PAGE_LAST_16 = createImageIcon(
    "PageLast16");

  /**
   * <img style="text-align:right;" src="../../../Print16.gif" alt="">
   * cone-padro 16x16 de uso geral: impresso.
   */
  public static final ImageIcon ICON_PRINT_16 = createImageIcon("Print16");

  /**
   * <img style="text-align:right;" src="../../../Print24.gif" alt="">
   * cone-padro 24x24 de uso geral: impresso.
   */
  public static final ImageIcon ICON_PRINT_24 = createImageIcon("Print24");

  /**
   * <img style="text-align:right;" src="../../../PrintPreview16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_PRINT_PREVIEW_16 = createImageIcon(
    "PrintPreview16");

  /**
   * <img style="text-align:right;" src="../../../PrintPreview24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_PRINT_PREVIEW_24 = createImageIcon(
    "PrintPreview24");

  /**
   * <img style="text-align:right;" src="../../../Transfer16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_TRANSFER_16 = createImageIcon(
    "Transfer16");

  /**
   * <img style="text-align:right;" src="../../../Transfer24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_TRANSFER_24 = createImageIcon(
    "Transfer24");

  /**
   * <img style="text-align:right;" src="../../../Stop16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_STOP_16 = createImageIcon("Stop16");

  /**
   * <img style="text-align:right;" src="../../../Stop24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_STOP_24 = createImageIcon("Stop24");

  /**
   * <img style="text-align:right;" src="../../../BrowseFile16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_BROWSEFILE_16 = createImageIcon(
    "BrowseFile16");

  /**
   * <img style="text-align:right;" src="../../../BrowseFile24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_BROWSEFILE_24 = createImageIcon(
    "BrowseFile24");

  /**
   * <img style="text-align:right;" src="../../../BrowseLocalFile16.gif" alt="">
   * cone-padro 16x16 de uso para busca de arquivos locais:
   */
  public static final ImageIcon ICON_BROWSELOCALFILE_16 = createImageIcon(
    "BrowseLocalFile16");

  /**
   * <img style="text-align:right;" src="../../../BrowseSGAFile16.gif" alt="">
   * cone-padro 16x16 de uso para busca de arquivos locais:
   */
  public static final ImageIcon ICON_BROWSESGAFILE_16 = createImageIcon(
    "BrowseSGA16");

  /**
   * <img style="text-align:right;" src="../../../ViewLog24.gif" alt="">
   * cone-padro 16x16 usar em boto que chama o visualizador de logs.
   */
  public static final ImageIcon ICON_VIEWLOG_16 = createImageIcon("ViewLog16");

  /**
   * <img style="text-align:right;" src="../../../ChangeColor16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_CHANGECOLOR_16 = createImageIcon(
    "ChangeColor16");

  /**
   * <img style="text-align:right;" src="../../../ChangeColor24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_CHANGECOLOR_24 = createImageIcon(
    "ChangeColor24");

  /**
   * <img style="text-align:right;" src="../../../Edit16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_EDIT_16 = createImageIcon("Edit16");

  /**
   * <img style="text-align:right;" src="../../../Edit24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_EDIT_24 = createImageIcon("Edit24");

  /**
   * <img style="text-align:right;" src="../../../Exit16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_EXIT_16 = createImageIcon("Exit16");

  /**
   * <img style="text-align:right;" src="../../../Exit24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_EXIT_24 = createImageIcon("Exit24");

  /**
   * <img style="text-align:right;" src="../../../RowDelete16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_ROWDELETE_16 = createImageIcon(
    "RowDelete16");

  /**
   * <img style="text-align:right;" src="../../../RowDelete24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_ROWDELETE_24 = createImageIcon(
    "RowDelete24");

  /**
   * <img style="text-align:right;" src="../../../RowInsertAfter16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_ROWINSERTAFTER_16 = createImageIcon(
    "RowInsertAfter16");

  /**
   * <img style="text-align:right;" src="../../../RowInsertAfter24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_ROWINSERTAFTER_24 = createImageIcon(
    "RowInsertAfter24");

  /**
   * <img style="text-align:right;" src="../../../RowInsertBefore16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_ROWINSERTBEFORE_16 = createImageIcon(
    "RowInsertBefore16");

  /**
   * <img style="text-align:right;" src="../../../RowInsertBefore24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_ROWINSERTBEFORE_24 = createImageIcon(
    "RowInsertBefore24");

  /**
   * <img style="text-align:right;" src="../../../RowDuplicate16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_ROWDUPLICATE_16 = createImageIcon(
    "RowDuplicate16");

  /**
   * <img style="text-align:right;" src="../../../ColumnDelete16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_COLUMNDELETE_16 = createImageIcon(
    "ColumnDelete16");

  /**
   * <img style="text-align:right;" src="../../../ColumnDelete24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_COLUMNDELETE_24 = createImageIcon(
    "ColumnDelete24");

  /**
   * <img style="text-align:right;" src="../../../ColumnInsertAfter16.gif" alt=
   * ""> cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_COLUMNINSERTAFTER_16 = createImageIcon(
    "ColumnInsertAfter16");

  /**
   * <img style="text-align:right;" src="../../../ColumnInsertAfter24.gif" alt=
   * ""> cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_COLUMNINSERTAFTER_24 = createImageIcon(
    "ColumnInsertAfter24");

  /**
   * <img style="text-align:right;" src="../../../ColumnInsertBefore16.gif" alt=
   * ""> cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_COLUMNINSERTBEFORE_16 = createImageIcon(
    "ColumnInsertBefore16");

  /**
   * <img style="text-align:right;" src="../../../ColumnInsertBefore24.gif" alt=
   * ""> cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_COLUMNINSERTBEFORE_24 = createImageIcon(
    "ColumnInsertBefore24");

  /**
   * <img style="text-align:right;" src="../../../Table16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_TABLE_16 = createImageIcon("Table16");

  /**
   * <img style="text-align:right;" src="../../../Table24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_TABLE_24 = createImageIcon("Table24");

  /**
   * <img style="text-align:right;" src="../../../About16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_ABOUT_16 = createImageIcon("About16");

  /**
   * <img style="text-align:right;" src="../../../About24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_ABOUT_24 = createImageIcon("About24");

  /**
   * <img style="text-align:right;" src="../../../Favorite16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_FAVORITE_16 = createImageIcon(
    "Favorite16");

  /**
   * <img style="text-align:right;" src="../../../Favorite16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_RECENT_16 = createPngImageIcon("Recent16");

  /**
   * <img style="text-align:right;" src="../../../Favorite10.gif" alt="">
   * cone-padro 10x10 de uso geral:
   */
  public static final ImageIcon ICON_FAVORITE_10 = createImageIcon(
    "Favorite10");

  /**
   * <img style="text-align:right;" src="../../../History16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_HISTORY_16 = createImageIcon("History16");

  /**
   * <img style="text-align:right;" src="../../../History24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_HISTORY_24 = createImageIcon("History24");

  /**
   * <img style="text-align:right;" src="../../../Preferences16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_PREFERENCES_16 = createImageIcon(
    "Preferences16");

  /**
   * <img style="text-align:right;" src="../../../Preferences24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_PREFERENCES_24 = createImageIcon(
    "Preferences24");

  /**
   * <img style="text-align:right;" src="../../../New16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_NEW_16 = createImageIcon("New16");

  /**
   * <img style="text-align:right;" src="../../../New24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_NEW_24 = createImageIcon("New24");

  /**
   * <img style="text-align:right;" src="../../../New16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_NEW_FOLDER_16 = createImageIcon(
    "NewFolder16");

  /**
   * <img style="text-align:right;" src="../../../Play16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_PLAY_16 = createImageIcon("Play16");

  /**
   * <img style="text-align:right;" src="../../../Play16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_MULTIPLAY_16 = createImageIcon(
    "MultiPlay16");

  /**
   * <img style="text-align:right;" src="../../../CommandScheduled16.gif" alt=
   * ""> cone para comandos agendados.
   */
  public static final ImageIcon ICON_SCHEDULED_CMD_16 = createImageIcon(
    "CommandScheduled16");

  /**
   * <img style="text-align:right;" src="../../../CommandSystemFailure16.gif"
   * alt=""> cone para comandos com falha na leitura.
   */
  public static final ImageIcon ICON_SYSTEM_FAILURE_CMD_16 = createImageIcon(
    "CommandSystemFailure16");

  /**
   * <img style="text-align:right;" src="../../../CommandExecution16.gif" alt=
   * ""> cone para execuo de comandos.
   */
  public static final ImageIcon ICON_EXECUTE_CMD_16 = createImageIcon(
    "CommandExecution16");

  /**
   * <img style="text-align:right;" src="../../../Interrupted16.gif" alt="">
   * cone para interrupo automtica de algoritmos em fluxos com erro.
   */
  public static final ImageIcon ICON_INTERRUPTED_CMD_16 = createImageIcon(
    "Interrupted16");

  /**
   * <img style="text-align:right;" src="../../../FatalError16.gif" alt="">
   * cone para erros que responsveis pela interrupo automtica da execuo
   * de um fluxo.
   */
  public static final ImageIcon ICON_FATAL_ERROR_16 = createPngImageIcon(
    "FatalError16");

  /**
   * <img style="text-align:right;" src="../../../NonFatalError16.gif" alt="">
   * cone para erros que no so responsveis pela interrupo automtica da
   * execuo de um fluxo.
   */
  public static final ImageIcon ICON_NON_FATAL_ERROR_16 = createPngImageIcon(
    "NonFatalError16");

  /**
   * <img style="text-align:right;" src="../../../Play24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_PLAY_24 = createImageIcon("Play24");

  /**
   * <img style="text-align:right;" src="../../../Refresh16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_REFRESH_16 = createImageIcon("Refresh16");

  /**
   * <img style="text-align:right;" src="../../../Refresh16.gif" alt=""> cone
   * para atualizao de um item.
   */
  public static final ImageIcon ICON_REFRESH_ONE_16 = createImageIcon(
    "RefreshOne16");

  /**
   * <img style="text-align:right;" src="../../../Refresh16.gif" alt=""> cone
   * para atualizao de um item.
   */
  public static final ImageIcon ICON_REFRESH_THIN_16 = createImageIcon(
    "RefreshThin16");

  /**
   * <img style="text-align:right;" src="../../../Refresh24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_REFRESH_24 = createImageIcon("Refresh24");

  /**
   * <img style="text-align:right;" src="../../../Zoom16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_ZOOM_16 = createImageIcon("Zoom16");

  /**
   * <img style="text-align:right;" src="../../../Zoom24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_ZOOM_24 = createImageIcon("Zoom24");

  /**
   * <img style="text-align:right;" src="../../../ZoomIn16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_ZOOMIN_16 = createImageIcon("ZoomIn16");

  /**
   * <img style="text-align:right;" src="../../../ZoomIn24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_ZOOMIN_24 = createImageIcon("ZoomIn24");

  /**
   * <img style="text-align:right;" src="../../../ZoomOut16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_ZOOMOUT_16 = createImageIcon("ZoomOut16");

  /**
   * <img style="text-align:right;" src="../../../ZoomOut24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_ZOOMOUT_24 = createImageIcon("ZoomOut24");

  /**
   * <img style="text-align:right;" src="../../../Layout16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_LAYOUT_16 = createImageIcon("Layout16");

  /**
   * <img style="text-align:right;" src="../../../Layout24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_LAYOUT_24 = createImageIcon("Layout24");

  /**
   * <img style="text-align:right;" src="../../../Rename16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_RENAME_16 = createImageIcon("Rename16");

  /**
   * <img style="text-align:right;" src="../../../Rename24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_RENAME_24 = createImageIcon("Rename24");

  /**
   * <img style="text-align:right;" src="../../../Pause16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_PAUSE_16 = createImageIcon("Pause16");

  /**
   * <img style="text-align:right;" src="../../../Pause24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_PAUSE_24 = createImageIcon("Pause24");

  /**
   * <img style="text-align:right;" src="../../../Add16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_ADD_16 = createImageIcon("Add16");

  /**
   * <img style="text-align:right;" src="../../../Add24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_ADD_24 = createImageIcon("Add24");

  /**
   * <img style="text-align:right;" src="../../../Export16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_EXPORT_16 = createImageIcon("Export16");

  /**
   * <img style="text-align:right;" src="../../../Export24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_EXPORT_24 = createImageIcon("Export24");

  /**
   * <img style="text-align:right;" src="../../../Import16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_IMPORT_16 = createImageIcon("Import16");

  /**
   * <img style="text-align:right;" src="../../../Import24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_IMPORT_24 = createImageIcon("Import24");

  /**
   * <img style="text-align:right;" src="../../../SaveAs16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_SAVEAS_16 = createImageIcon("SaveAs16");

  /**
   * <img style="text-align:right;" src="../../../SaveAs16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_SAVEAS_LOCAL_16 = createImageIcon(
    "SaveAsLocal16");

  /**
   * <img style="text-align:right;" src="../../../SaveAs24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_SAVEAS_24 = createImageIcon("SaveAs24");

  /**
   * <img style="text-align:right;" src="../../../Save16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_SAVE_16 = createImageIcon("Save16");

  /**
   * <img style="text-align:right;" src="../../../Save24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_SAVE_24 = createImageIcon("Save24");

  /**
   * <img style="text-align:right;" src="../../../Invalidate16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_INVALIDATE_16 = createImageIcon(
    "Invalidate16");

  /**
   * <img style="text-align:right;" src="../../../Invalidate24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_INVALIDATE_24 = createImageIcon(
    "Invalidate24");

  /**
   * <img style="text-align:right;" src="../../../Clone16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_CLONE_16 = createImageIcon("Clone16");

  /**
   * <img style="text-align:right;" src="../../../Clone24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_CLONE_24 = createImageIcon("Clone24");

  /**
   * <img style="text-align:right;" src="../../../Close16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_CLOSE_16 = createImageIcon("Close16");

  /**
   * <img style="text-align:right;" src="../../../Close24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_CLOSE_24 = createImageIcon("Close24");

  /**
   * <img style="text-align:right;" src="../../../List16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_LIST_16 = createImageIcon("List16");

  /**
   * <img style="text-align:right;" src="../../../List24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_LIST_24 = createImageIcon("List24");

  /**
   * <img style="text-align:right;" src="../../../Open16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_OPEN_16 = createImageIcon("Open16");

  /**
   * <img style="text-align:right;" src="../../../OpenLocal16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_OPEN_LOCAL_16 = createImageIcon(
    "OpenLocal16");

  /**
   * <img style="text-align:right;" src="../../../Open24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_OPEN_24 = createImageIcon("Open24");

  /**
   * <img style="text-align:right;" src="../../../Forward16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_FORWARD_16 = createImageIcon("Forward16");

  /**
   * <img style="text-align:right;" src="../../../Forward24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_FORWARD_24 = createImageIcon("Forward24");

  /**
   * <img style="text-align:right;" src="../../../Properties16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_PROPERTIES_16 = createImageIcon(
    "Properties16");

  /**
   * <img style="text-align:right;" src="../../../Properties24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_PROPERTIES_24 = createImageIcon(
    "Properties24");

  /**
   * <img style="text-align:right;" src="../../../Back16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_BACK_16 = createImageIcon("Back16");

  /**
   * <img style="text-align:right;" src="../../../Back24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_BACK_24 = createImageIcon("Back24");

  /**
   * <img style="text-align:right;" src="../../../Paste16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_PASTE_16 = createImageIcon("Paste16");

  /**
   * <img style="text-align:right;" src="../../../Paste24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_PASTE_24 = createImageIcon("Paste24");

  /**
   * <img style="text-align:right;" src="../../../Copy16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_COPY_16 = createImageIcon("Copy16");

  /**
   * <img style="text-align:right;" src="../../../Copy24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_COPY_24 = createImageIcon("Copy24");

  /**
   * <img style="text-align:right;" src="../../../Cut16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_CUT_16 = createImageIcon("Cut16");

  /**
   * <img style="text-align:right;" src="../../../Cut24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_CUT_24 = createImageIcon("Cut24");

  /**
   * <img style="text-align:right;" src="../../../Delete16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_DELETE_16 = createImageIcon("Delete16");

  /**
   * <img style="text-align:right;" src="../../../Delete24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_DELETE_24 = createImageIcon("Delete24");

  /**
   * <img style="text-align:right;" src="../../../Find16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_FIND_16 = createImageIcon("Find16");

  /**
   * <img style="text-align:right;" src="../../../FindNext16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_FIND_NEXT_16 = createImageIcon(
    "FindNext16");

  /**
   * <img style="text-align:right;" src="../../../Find16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_FIND_PREV_16 = createImageIcon(
    "FindPrev16");

  /**
   * <img style="text-align:right;" src="../../../Find16.gif" alt=""> cone para
   * buscar usurio.
   */
  public static final ImageIcon ICON_FIND_USER_16 = createImageIcon(
    "FindUser16");

  /**
   * <img style="text-align:right;" src="../../../Find24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_FIND_24 = createImageIcon("Find24");

  /**
   * <img style="text-align:right;" src="../../../Details16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_DETAILS_16 = createImageIcon("Details16");

  /**
   * <img style="text-align:right;" src="../../../Details24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_DETAILS_24 = createImageIcon("Details24");

  /**
   * <img style="text-align:right;" src="../../../Preview16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_PREVIEW_16 = createImageIcon("Preview16");

  /**
   * <img style="text-align:right;" src="../../../Preview24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_PREVIEW_24 = createImageIcon("Preview24");

  /**
   * <img style="text-align:right;" src="../../../ComposeMail16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_COMPOSEMAIL_16 = createImageIcon(
    "ComposeMail16");

  /**
   * <img style="text-align:right;" src="../../../ComposeMail24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_COMPOSEMAIL_24 = createImageIcon(
    "ComposeMail24");

  /**
   * <img style="text-align:right;" src="../../../ComposeMsg16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_COMPOSEMSG_16 = createImageIcon(
    "ComposeMsg16");

  /**
   * <img style="text-align:right;" src="../../../ComposeMsg24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_COMPOSEMSG_24 = createImageIcon(
    "ComposeMsg24");

  /**
   * <img style="text-align:right;" src="../../../ComposeMsg32.gif" alt="">
   * cone-padro 32x32 de uso geral:
   */
  public static final ImageIcon ICON_COMPOSEMSG_32 = createImageIcon(
    "ComposeMsg32");

  /**
   * <img style="text-align:right;" src="../../../ClearMsg16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_CLEARMSG_16 = createImageIcon(
    "ClearMsg16");

  /**
   * <img style="text-align:right;" src="../../../ClearMsg24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_CLEARMSG_24 = createImageIcon(
    "ClearMsg24");

  /**
   * <img style="text-align:right;" src="../../../ClearMsg32.gif" alt="">
   * cone-padro 32x32 de uso geral:
   */
  public static final ImageIcon ICON_CLEARMSG_32 = createImageIcon(
    "ClearMsg32");

  /**
   * <img style="text-align:right;" src="../../../Help16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_HELP_16 = createImageIcon("Help16");

  /**
   * <img style="text-align:right;" src="../../../Help24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_HELP_24 = createImageIcon("Help24");

  /**
   * <img style="text-align:right;" src="../../../Notes16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_NOTES_16 = createImageIcon("Notes16");

  /**
   * <img style="text-align:right;" src="../../../Notes24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_NOTES_24 = createImageIcon("Notes24");

  /**
   * <img style="text-align:right;" src="../../../TurnOn16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_TURNON_16 = createImageIcon("TurnOn16");

  /**
   * <img style="text-align:right;" src="../../../TurnOn24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_TURNON_24 = createImageIcon("TurnOn24");

  /**
   * <img style="text-align:right;" src="../../../TurnOff16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_TURNOFF_16 = createImageIcon("TurnOff16");

  /**
   * <img style="text-align:right;" src="../../../TurnOff24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_TURNOFF_24 = createImageIcon("TurnOff24");

  /**
   * <img style="text-align:right;" src="../../../Ok16.gif" alt=""> cone-padro
   * 16x16 de uso geral:
   */
  public static final ImageIcon ICON_OK_16 = createImageIcon("Ok16");

  /**
   * <img style="text-align:right;" src="../../../Ok24.gif" alt=""> cone-padro
   * 24x24 de uso geral:
   */
  public static final ImageIcon ICON_OK_24 = createImageIcon("Ok24");

  /**
   * <img style="text-align:right;" src="../../../Cancel16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_CANCEL_16 = createImageIcon("Cancel16");

  /**
   * <img style="text-align:right;" src="../../../Cancel24.gif" alt="">
   * cone-padro 24x24 de uso geral
   */
  public static final ImageIcon ICON_CANCEL_24 = createImageIcon("Cancel24");

  /**
   * <img style="text-align:right;" src="../../../Filter16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_FILTER_16 = createImageIcon("Filter16");

  /**
   * <img style="text-align:right;" src="../../../Filter24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_FILTER_24 = createImageIcon("Filter24");

  /**
   * <img style="text-align:right;" src="../../../Lock16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_LOCK_16 = createImageIcon("Lock16");

  /**
   * <img style="text-align:right;" src="../../../Lock16.gif" alt=""> cone
   * indica projetos privados.
   */
  public static final ImageIcon ICON_PRIVATE_16 = createImageIcon("Private16");

  /**
   * <img style="text-align:right;" src="../../../Lock16.gif" alt=""> cone
   * indica projetos compartilhado.
   */
  public static final ImageIcon ICON_SHARED_16 = createImageIcon("Shared16");

  /**
   * <img style="text-align:right;" src="../../../Lock16.gif" alt=""> cone
   * indica projetos pblico.
   */
  public static final ImageIcon ICON_PUBLIC_16 = createImageIcon("Public16");

  /**
   * <img style="text-align:right;" src="../../../Lock24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_LOCK_24 = createImageIcon("Lock24");

  /**
   * <img style="text-align:right;" src="../../../Unlock16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_UNLOCK_16 = createImageIcon("Unlock16");

  /**
   * <img style="text-align:right;" src="../../../Unlock24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_UNLOCK_24 = createImageIcon("Unlock24");

  /**
   * <img style="text-align:right;" src="../../../Reset16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_RESET_16 = createImageIcon("Reset16");

  /**
   * <img style="text-align:right;" src="../../../Reset24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_RESET_24 = createImageIcon("Reset24");

  /**
   * <img style="text-align:right;" src="../../../Apply16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_APPLY_16 = createImageIcon("Apply16");

  /**
   * <img style="text-align:right;" src="../../../Apply24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_APPLY_24 = createImageIcon("Apply24");

  /**
   * <img style="text-align:right;" src="../../../Wizard16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_WIZARD_16 = createImageIcon("Wizard16");

  /**
   * <img style="text-align:right;" src="../../../Wizard24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_WIZARD_24 = createImageIcon("Wizard24");

  /**
   * <img style="text-align:right;" src="../../../Tree16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_TREE_16 = createImageIcon("Tree16");

  /**
   * <img style="text-align:right;" src="../../../Tree24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_TREE_24 = createImageIcon("Tree24");

  /**
   * <img style="text-align:right;" src="../../../LeftFit16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_LEFTFIT_16 = createImageIcon("LeftFit16");

  /**
   * <img style="text-align:right;" src="../../../LeftFit24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_LEFTFIT_24 = createImageIcon("LeftFit24");

  /**
   * <img style="text-align:right;" src="../../../RightFit16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_RIGHTFIT_16 = createImageIcon(
    "RightFit16");

  /**
   * <img style="text-align:right;" src="../../../RightFit24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_RIGHTFIT_24 = createImageIcon(
    "RightFit24");

  /**
   * <img style="text-align:right;" src="../../../DownFit16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_DOWNFIT_16 = createImageIcon("DownFit16");

  /**
   * <img style="text-align:right;" src="../../../DownFit24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_DOWNFIT_24 = createImageIcon("DownFit24");

  /**
   * <img style="text-align:right;" src="../../../UpFit16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_UPFIT_16 = createImageIcon("UpFit16");

  /**
   * <img style="text-align:right;" src="../../../UpFit24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_UPFIT_24 = createImageIcon("UpFit24");

  /**
   * <img style="text-align:right;" src="../../../VerticalFit16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_VERTICALFIT_16 = createImageIcon(
    "VerticalFit16");

  /**
   * <img style="text-align:right;" src="../../../VerticalFit24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_VERTICALFIT_24 = createImageIcon(
    "VerticalFit24");

  /**
   * <img style="text-align:right;" src="../../../HorizontalFit16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_HORIZONTALFIT_16 = createImageIcon(
    "HorizontalFit16");

  /**
   * <img style="text-align:right;" src="../../../HorizontalFit24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_HORIZONTALFIT_24 = createImageIcon(
    "HorizontalFit24");

  /**
   * <img style="text-align:right;" src="../../../RightArrow24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_RIGHT_ARROW_24 = createImageIcon(
    "RightArrow24");

  /**
   * <img style="text-align:right;" src="../../../DownArrow24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_DOWN_ARROW_24 = createImageIcon(
    "DownArrow24");

  /**
   * <img style="text-align:right;" src="../../../DisabledDownArrow24.gif" alt=
   * ""> cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_DISABLED_DOWN_ARROW_24 = createImageIcon(
    "DisabledDownArrow24");

  /**
   * <img style="text-align:right;" src="../../../Redo16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_REDO_16 = createImageIcon("Redo16");

  /**
   * <img style="text-align:right;" src="../../../Redo24.gif" alt="">
   * cone-padro 24x24 de uso geral:
   */
  public static final ImageIcon ICON_REDO_24 = createImageIcon("Redo24");

  /**
   * <img style="text-align:right;" src="../../../None.gif" alt=""> Imagem
   * repesentante de erro no acesso a um resource de imagem.
   */
  public static final ImageIcon ICON_NONE = createImageIcon("None");

  /**
   * <img style="text-align:right;" src="../../../Link16.gif" alt="">
   * Icone-padro 16x16 de uso geral:
   */
  public static final ImageIcon ICON_LINK_16 = createImageIcon("Link16");

  /**
   * <img style="text-align:right;" src="../../../Information32.png" alt="">
   * Imagem 32x32 indicativo de tipo de mensagem em dilogos: Informao (novo)
   */
  public static final ImageIcon ICON_INFORMATION_32 = createPngImageIcon(
    "Information32");

  /**
   * <img style="text-align:right;" src="../../../Question32.png" alt=""> Imagem
   * 32x32 indicativo de tipo de mensagem em dilogos: Pergunta (novo)
   */
  public static final ImageIcon ICON_QUESTION_32 = createPngImageIcon(
    "Question32");

  /**
   * <img style="text-align:right;" src="../../../Error32.png" alt=""> Imagem
   * 32x32 indicativo de tipo de mensagem em dilogos: Erro (novo)
   */
  public static final ImageIcon ICON_ERROR_32 = createPngImageIcon("Error32");

  /**
   * <img style="text-align:right;" src="../../../Warning32.png" alt=""> Imagem
   * 32x32 indicativo de tipo de mensagem em dilogos: Alerta (novo)
   */
  public static final ImageIcon ICON_WARNING_32 = createPngImageIcon(
    "Warning32");

  /**
   * <img style="text-align:right;" src="../../../Information24.png" alt="">
   * Imagem 24x24 indicativo de tipo de mensagem em dilogos: Informao (novo)
   */
  public static final ImageIcon ICON_INFORMATION_24 = createPngImageIcon(
    "Information24");

  /**
   * <img style="text-align:right;" src="../../../Question24.png" alt=""> Imagem
   * 24x24 indicativo de tipo de mensagem em dilogos: Pergunta (novo)
   */
  public static final ImageIcon ICON_QUESTION_24 = createPngImageIcon(
    "Question24");

  /**
   * <img style="text-align:right;" src="../../../Error24.png" alt=""> Imagem
   * 24x24 indicativo de tipo de mensagem em dilogos: Erro (novo)
   */
  public static final ImageIcon ICON_ERROR_24 = createPngImageIcon("Error24");

  /**
   * <img style="text-align:right;" src="../../../Warning24.png" alt=""> Imagem
   * 24x24 indicativo de tipo de mensagem em dilogos: Alerta (novo)
   */
  public static final ImageIcon ICON_WARNING_24 = createPngImageIcon(
    "Warning24");

  /**
   * <img style="text-align:right;" src="../../../Information16.png" alt="">
   * Imagem 16x16 indicativo de tipo de mensagem em dilogos: Informao (novo)
   */
  public static final ImageIcon ICON_INFORMATION_16 = createPngImageIcon(
    "Information16");

  /**
   * <img style="text-align:right;" src="../../../Question16.png" alt=""> Imagem
   * 16x16 indicativo de tipo de mensagem em dilogos: Pergunta (novo)
   */
  public static final ImageIcon ICON_QUESTION_16 = createPngImageIcon(
    "Question16");

  /**
   * <img style="text-align:right;" src="../../../Error16.png" alt=""> Imagem
   * 16x16 indicativo de tipo de mensagem em dilogos: Erro (novo)
   */
  public static final ImageIcon ICON_ERROR_16 = createPngImageIcon("Error16");

  /**
   * <img style="text-align:right;" src="../../../Warning16.png" alt=""> Imagem
   * 16x16 indicativo de tipo de mensagem em dilogos: Alerta (novo)
   */
  public static final ImageIcon ICON_WARNING_16 = createPngImageIcon(
    "Warning16");

  /**
   * <img style="text-align:right;" src="../../../EditableTableCell14.png" alt=
   * ""> Imagem com 14 pixels de altura que indica que uma clula de tabela 
   * editvel.
   */
  public static final ImageIcon ICON_EDITABLE_TABLE_CELL_14 = createImageIcon(
    "EditableTableCell14");

  /**
   * <img style="text-align:right;" src="../../../RedBall16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon RED_BALL_16 = createImageIcon("RedBall16");

  /**
   * <img style="text-align:right;" src="../../../YellowBall16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon YELLOW_BALL_16 = createImageIcon(
    "YellowBall16");

  /**
   * <img style="text-align:right;" src="../../../GreenBall16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon GREEN_BALL_16 = createImageIcon("GreenBall16");

  /**
   * <img style="text-align:right;" src="../../../GrayBall16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon GRAY_BALL_16 = createImageIcon("GrayBall16");

  /**
   * <img style="text-align:right;" src="../../../TransparentBall16.gif" alt="">
   * cone-padro 16x16 de uso geral:
   */
  public static final ImageIcon TRANSPARENT_BALL_16 = createImageIcon(
    "TransparentBall16");

  /**
   * Diretrio das imagens padro do CSBASE.
   */
  private static final String IMAGE_DIRECTORY =
    "/csbase/client/resources/applicationimages/";

  /**
   * Extenso dos arquivos (formato) das imagens padronizadas.
   */
  private static final String IMAGE_EXTENSION = "gif";

  /**
   * Extenso dos arquivos (formato) das imagens png.
   */
  protected static final String IMAGE_PNG_EXTENSION = "png";

  /**
   * Construtor.
   */
  protected ApplicationImages() {
    //Construtor privado para no haver instanciao.
  }

  /**
   * Montagem da cone do diretrio-padro.
   *
   * @param imageIconName nome do arquivo de imagem.
   * @return uma imagem (cone)
   */
  protected static ImageIcon createImageIcon(String imageIconName) {
    return createImageIcon(imageIconName, IMAGE_DIRECTORY);
  }

  /**
   * Montagem da cone do diretrio-padro a partir de imagem .PNG.
   *
   * @param imageIconName nome do arquivo de imagem .PNG.
   * @return uma imagem (cone)
   */
  protected static ImageIcon createPngImageIcon(String imageIconName) {
    return createImageIcon(imageIconName, IMAGE_DIRECTORY, IMAGE_PNG_EXTENSION);
  }

  /**
   * Montagem da cone do diretrio-padro.
   *
   * @param imageIconName nome do arquivo de imagem.
   * @param imageDir Caminho do diretrio das imagens
   * @return uma imagem (cone)
   */
  protected static ImageIcon createImageIcon(String imageIconName,
    String imageDir) {
    return createImageIcon(imageIconName, imageDir, IMAGE_EXTENSION);
  }

  /**
   * Montagem da cone do diretrio-padro.
   *
   * @param imageIconName nome do arquivo de imagem.
   * @param imageDir Caminho do diretrio das imagens
   * @param imageExtension Extenso do arquivo de imagem
   * @return uma imagem (cone)
   */
  protected static ImageIcon createImageIcon(String imageIconName,
    String imageDir, String imageExtension) {
    String resPath = imageDir + imageIconName + "." + imageExtension;
    URL res = ApplicationImages.class.getResource(resPath);
    if (res == null) {
      System.err.println(
        "No foi possvel criar a imagem padro de aplicao.\n"
          + "Nome do cone: " + imageIconName);
      return ICON_NONE;
    }
    return new ImageIcon(res);
  }
}
