package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.algorithmsmanager.actions.AlgorithmManagementAction;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;

/**
 * Classe que define o painel para a funcionalidade de gerenciamento de
 * algoritmos, na aplicao Gerenciador de Algoritmos.
 * 
 * Esse painel possui a estrutura comum definida na classe
 * <code> CommonManagementPanel </code>, e cria o painel de seleo de dados e o
 * painel de edio do dado selecionado.
 * 
 */
public class AlgorithmManagementPanel extends CommonManagementPanel {

  /**
   * Constri o painel.
   * 
   * @param action ao que criou esse painel
   */
  public AlgorithmManagementPanel(AlgorithmManagementAction action) {
    super(action);
  }

  @Override
  protected CommonEditTabbedPanel buildEditPanel() {
    CommonEditTabbedPanel editPanel = new AlgorithmEditDataPanel(
      getManagementAction());
    return editPanel;
  }

  @Override
  protected CommonSelectionPanel buildSelectionPanel() {
    CommonSelectionPanel selectionPanel = new AlgorithmSelectionPanel(
      getManagementAction());
    return selectionPanel;
  }

  @Override
  public AlgorithmManagementAction getManagementAction() {
    return (AlgorithmManagementAction) super.getManagementAction();
  }

  @Override
  public AlgorithmSelectionPanel getSelectionPanel() {
    if (super.getSelectionPanel() == null)
      return null;
    return (AlgorithmSelectionPanel) super.getSelectionPanel();
  }

  /**
   * Atribui o algoritmo selecionado ao painel de edio (atualizao do dado).
   * 
   * @param item item selecionado para alterao
   */
  public void changeAlgorithmItemEdition(AlgorithmListItem item) {
    if (getEditPanel() != null) {
      ((AlgorithmEditDataPanel) getEditPanel())
        .changeAlgorithmItemEdition(item);
    }
  }

}
