package csbase.client.csdk.v2.extras.rest;

import org.glassfish.jersey.server.ResourceConfig;

import csbase.client.csdk.v2.core.CSDKAbstractContext;
import csbase.client.rest.RestController;
import csdk.v2.extras.context.rest.IRestContext;
import csdk.v2.extras.context.rest.RestException;
import tecgraf.javautils.core.lng.LNG;

/**
 * Implementao do contexto REST do CSDK no ambiente, que permite basicamente o
 * registro/desregistro de recursos REST da aplicao no cliente.
 */
public class CSDKRestContext extends CSDKAbstractContext implements
  IRestContext {

  /**
   * Identificador da instncia da aplicao.
   */
  private final String instanceId;

  /**
   * Construtor.
   *
   * @param instanceId identificador da instncia da aplicao.
   */
  public CSDKRestContext(String instanceId) {
    this.instanceId = instanceId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void registerResources(
    ResourceConfig resourceConfig) throws RestException {
    RestController restController = RestController.getInstance();
    if (!resourceConfig.getInstances().isEmpty() && resourceConfig
      .getClasses().isEmpty()) {
      restController.addApplicationResources(instanceId, resourceConfig);
    }
    else {
      String errorMsg =
        LNG.get(CSDKRestContext.class.getSimpleName() + ".rest.register.error");
      throw new RestException(errorMsg);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void unregisterResources() {
    RestController restController = RestController.getInstance();
    restController.removeApplicationResources(instanceId);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void contextDeactivated() {
    unregisterResources();
  }
}
