package csbase.client.desktop.instancestoolbar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.CompoundBorder;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationManagerListener;
import csbase.client.applicationmanager.ApplicationType;
import csbase.logic.applicationservice.ApplicationRegistry;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

/**
 * @author Tecgraf/PUC-Rio
 */
public class ApplicationInstancesToolbar extends JPanel implements
  ApplicationManagerListener {

  /**
   * Tam imagem
   */
  final static private int IMG_SIZE = 16;

  /**
   * Cor nula
   */
  private static final Color NULL_COLOR = new JLabel().getBackground();

  /**
   * Painel de cones de aplicativos.
   */
  private final JPanel appPanel = new JPanel();

  /**
   * Colocao de uma borda com linha e texto em um componente.
   *
   * @param component o componente a ser colocado sob a borda.
   * @param highlight indicativo
   */
  protected static void setWidgetBorder(final JComponent component,
    final boolean highlight) {
    final Color color = (highlight ? Color.gray : NULL_COLOR);
    final int brdy_o = 0;
    final int brdy_i = 5;
    final int brd = 0;
    final CompoundBorder border = BorderFactory.createCompoundBorder(
      BorderFactory.createEmptyBorder(brdy_o, brd, brdy_o, brd), BorderFactory
        .createCompoundBorder(BorderFactory.createLineBorder(color),
          BorderFactory.createEmptyBorder(brdy_i, brd, brdy_i, brd)));
    component.setBorder(border);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void applicationEnded(String id) {
    updateWidgets();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void applicationStarted(String id) {
    updateWidgets();
  }

  /**
   * Remonta os widgets
   */
  private void updateWidgets() {
    appPanel.removeAll();
    final GridBagLayout layout = new GridBagLayout();
    appPanel.setLayout(layout);

    final ApplicationManager mng = ApplicationManager.getInstance();
    final Hashtable<String, Vector<ApplicationType>> apps = mng
      .getRunningApplications();
    final Enumeration<String> keys = apps.keys();
    int numWidgets = 0;
    for (Enumeration<String> e = keys; e.hasMoreElements();) {
      final String id = e.nextElement();
      final ApplicationRegistry reg = mng.getApplicationRegistry(id);
      final Vector<ApplicationType> instances = apps.get(id);
      final int numInstances = instances.size();
      if (numInstances > 0) {
        final JComponent widget = createWidget(reg, instances);
        appPanel.add(widget, new GBC(numWidgets, 0).center());
        numWidgets++;
      }
    }
    appPanel.add(new JPanel(), new GBC(numWidgets, 0).center().horizontal());

    final JComponent[] components = new JComponent[numWidgets];
    for (int i = 0; i < numWidgets; i++) {
      components[i] = (JComponent) appPanel.getComponent(i);
    }
    GUIUtils.matchPreferredSizes(components);
    appPanel.validate();
    appPanel.repaint();
  }

  /**
   * Cria o widget
   *
   * @param reg registry da aplicao.
   * @param instances instncias da aplicao.
   * @return o widget.
   */
  private JComponent createWidget(final ApplicationRegistry reg,
    final Vector<ApplicationType> instances) {
    final JLabel widget = new JLabel();
    widget.setText(" (" + instances.size() + ")");
    widget.setFont(widget.getFont().deriveFont(Font.PLAIN));

    final ApplicationManager appManager = ApplicationManager.getInstance();
    widget.setToolTipText(appManager.getApplicationName(reg));
    ImageIcon icon = null;
    final byte[] iconDefinition = reg.getIconDefinition();
    if (iconDefinition != null) {
      icon = new ImageIcon(iconDefinition);
    }
    widget.setIcon(icon);
    widget.setOpaque(true);
    widget.setHorizontalAlignment(SwingConstants.CENTER);
    widget.setVerticalAlignment(SwingConstants.CENTER);
    final int h = (int) Math.round(IMG_SIZE * 1.1);
    final Dimension dim = new Dimension(75, h);
    widget.setMinimumSize(dim);
    widget.setPreferredSize(dim);
    widget.setSize(dim);

    final ApplicationInstancesToolbarMouseAdapter adp =
      new ApplicationInstancesToolbarMouseAdapter(widget, instances);
    widget.addMouseListener(adp);
    setWidgetBorder(widget, false);
    return widget;
  }

  /**
   * Construtor
   */
  public ApplicationInstancesToolbar() {
    final ApplicationManager mng = ApplicationManager.getInstance();
    mng.addListener(this);

    final int h = (int) (Math.round(IMG_SIZE * 1.6));
    final Dimension dim = new Dimension(30, h);
    appPanel.setMinimumSize(dim);
    appPanel.setSize(dim);
    appPanel.setPreferredSize(dim);

    setLayout(new GridBagLayout());
    add(appPanel, new GBC(1, 0).center().horizontal());
  }

}
