package csbase.client.util.table;

import csbase.exception.ParseException;

/**
 * Conversor de <i>Double</i>.
 */
public final class DoubleConverter implements Converter {
  public Object convertFromView(String value) throws ParseException {
    try {
      return Double.parseDouble(value);
    } catch (NumberFormatException e) {
      throw new ParseException("O valor informado no  um nmero real.");
    }
  }

  public String convertToView(Object value) {
    return value.toString();
  }
}
