/**
 * $Id$
 */
package csbase.client.desktop;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

/**
 * Dilogo de escolha de novo login para o qual se deseja logar
 *
 * @author Tecgraf
 */
public class LoginAsDialog extends DesktopComponentDialog {

  /** Lista de logins para os quais ele pode logar numa combo */
  private JComboBox combo;

  /** login selecionado */
  private String selectedNewUser;

  /** Lista de logins disponveis para aquele usurio */
  private String[] availableLogins;

  /**
   * Construtor
   *
   * @param desktopFrame o desktop do sistema.
   * @param availableLogins lista de logins disponveis para aquele usurio
   *        logar como. No pode ser vazia: a action tem que ser desabilitada
   *        neste caso:
   *        loginAsMenuItem.setEnabled(loginAsDesktopAction.hasAvailableLogins()
   *        );
   */
  public LoginAsDialog(final DesktopFrame desktopFrame,
    String[] availableLogins) {
    super(desktopFrame.getDesktopFrame());

    this.availableLogins = availableLogins;
    setTitle(LNG.get("LoginAsDialog.title"));
    final JPanel mainPanel = new JPanel();
    mainPanel.setLayout(new BorderLayout());
    mainPanel.add(buildMainPanel(), BorderLayout.CENTER);
    mainPanel.add(buildButtonsPanel(), BorderLayout.SOUTH);
    final Container container = this.getContentPane();
    container.add(mainPanel);
    pack();
    setResizable(false);
  }

  /**
   * Cria o painel principal
   *
   * @return painel
   */
  protected JPanel buildMainPanel() {
    JPanel mainPanel = new JPanel(new GridBagLayout());
    GBC gbc = new GBC(0, 0).northwest().horizontal().insets(10, 10, 0, 0);
    JLabel comboLabel = new JLabel(LNG.get("LoginAsDialog.comboLabel"));
    mainPanel.add(comboLabel, gbc);
    combo = new JComboBox(availableLogins);
    gbc = new GBC(0, 1).northwest().horizontal().insets(10, 10, 0, 10);
    mainPanel.add(combo, gbc);
    return mainPanel;
  }

  /**
   * Cria o painel de botes.
   *
   * @return painel
   */
  protected JPanel buildButtonsPanel() {
    final JPanel panel = new JPanel(new FlowLayout());

    final JButton cancelButton =
      new JButton(LNG.get("notification.cancel.button"));
    cancelButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent ev) {
        close();
      }
    });

    final JButton okButton = new JButton(LNG.get("UserDialog.button.confirm"));
    okButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent ev) {
        setSelectedNewUser();
        close();
      }
    });

    panel.add(okButton);
    panel.add(cancelButton);
    GUIUtils.matchPreferredSizes(new JComponent[] { okButton, cancelButton });

    return panel;
  }

  /**
   * Atribui o usurio selecionado ao correntemente escolhido na combo
   */
  private void setSelectedNewUser() {
    this.selectedNewUser = (String) combo.getSelectedItem();
  }

  /**
   * Devolve o novo login selecionado
   *
   * @return o novo login selecionado
   */
  public String getSelectedNewUser() {
    return this.selectedNewUser;
  }
}