package csbase.client.preferences.definition;

import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.annotations.Editor;
import csbase.client.preferences.annotations.Hidden;
import csbase.client.preferences.annotations.ReadOnly;
import csbase.client.preferences.annotations.ReadWrite;
import csbase.client.preferences.annotations.Value;

/**
 * Interface a ser implementada pelas enumeraes que definem preferncias do
 * usurio.
 * 
 * Para que uma aplicao defina seu conjunto de preferncias, basta criar uma
 * enumerao que implementa esta interface. Alm disso,  necessrio que essa
 * enumerao seja nomeada seguindo a conveno {@code <}Nome da classe da
 * aplicao{@code >} + "Pref".
 * 
 * Veja abaixo um exemplo de como criar a definio de um conjunto de
 * preferncias:
 * 
 * <code>
 * enum NotepadPref implements PreferenceDefinition {
 * 
 * \@ReadWrite
 * \@Value(type = PVInteger.class, defaultValue = "800") 
 * WIDTH,
 * 
 * \@ReadWrite
 * \@Value(type = PVInteger.class, defaultValue = "800") 
 * HEIGHT;
 * } 
 * </code>
 * 
 * No cdigo acima, cada constante denota uma preferncia. Esta constante deve
 * ser anotada com a anotao {@link Value} onde definimos qual a classe que
 * encapsula um valor de preferncia e qual o seu valor default. Alm disso, 
 * possvel descrevermos qual a poltica de visibilidade da preferncia usando
 * as anotaes {@link Hidden}, {@link ReadWrite} e {@link ReadOnly}.
 * 
 * Basicamente, cada enumerao  mapeada para um conceito que chamamos de
 * categoria. Uma categoria nada mais  do que um agregador de preferncias.
 * Tambm  possvel criarmos categorias aninhadas. Para isso, podemos
 * refernciar uma outra enumerao ou podemos declarar uma nova enumerao
 * aninhada. Obviamente, essa enumerao aninhada tambm deve seguir as mesmas
 * convenes (implementar {@link PreferenceDefinition}).
 * 
 * As anotaes disponveis so:
 * 
 * @see Hidden
 * @see ReadOnly
 * @see ReadWrite
 * @see Editor
 * @see Value
 * 
 *      Outras classes teis que fazem parte da lgica do sistema de
 *      preferncias:
 * 
 * @see PreferenceValue PreferenceCategory PreferenceManager
 * 
 * @author Tecgraf
 */
public interface PreferenceDefinition {
}
