/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms;

import csbase.logic.algorithms.parameters.ParameterDocumentation;
import csbase.logic.algorithms.parameters.ParameterRegistry;
import csbase.logic.algorithms.parsers.MultipleParameterFactory;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.logic.algorithms.parsers.elements.IElementStructure;
import csbase.logic.algorithms.parsers.elements.attributes.IElementAttribute;
import csbase.remote.ClientRemoteLocator;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

public class ParametersDescriptionDialog
extends JDialog {
    private Map<String, ParameterFactory> factories;
    private JEditorPane textArea;
    private ParameterRegistry registry;
    private Locale locale;
    private static int DEFAULT_MARGIN = 25;
    private static int MULTIPLE_VALUES_MARGIN = 15;
    private static int ATTRIBUTE_MARGIN = 35;
    private static int CHILDREN_TITLE_MARGIN = 35;
    private static int CHILDREN_CONTENT_MARGIN = 60;

    public ParametersDescriptionDialog(Window owner, Dialog.ModalityType modality, Map<String, ParameterFactory> factories) {
        super(owner, Dialog.ModalityType.MODELESS);
        this.setTitle(LNG.get((String)"ParametersDescriptionDialog.title"));
        this.factories = factories;
        try {
            this.registry = ClientRemoteLocator.algorithmService.getParameterRegistry();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.locale = LNG.getLocale();
        this.addEscListener();
        this.setDefaultCloseOperation(2);
        String content = this.describeParameters();
        this.mountPanel();
        this.updateTextArea(content);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void addEscListener() {
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParametersDescriptionDialog.this.dispose();
            }
        };
        boolean mode = true;
        InputMap inputMap = this.rootPane.getInputMap(1);
        ActionMap actionMap = this.rootPane.getActionMap();
        int esc = 27;
        KeyStroke cancelStroke = KeyStroke.getKeyStroke(27, 0);
        String actionMapKey = cancelStroke.toString();
        inputMap.put(cancelStroke, actionMapKey);
        actionMap.put(actionMapKey, cancelAction);
    }

    private String describeParameters() {
        StringBuilder str = new StringBuilder();
        for (ParameterFactory factory : this.factories.values()) {
            String description = this.getDescription(factory);
            str.append(description);
        }
        return str.toString();
    }

    private String getDescription(ParameterFactory factory) {
        StringBuilder description = new StringBuilder();
        IElementStructure structure = (IElementStructure)factory.getParameterStructures().get(0);
        description.append("<h1>");
        description.append(LNG.get((String)"ParametersDescriptionDialog.element") + " " + structure.getName());
        description.append("</h1>");
        if (MultipleParameterFactory.class.isInstance(factory)) {
            MultipleParameterFactory multipleFactory = (MultipleParameterFactory)factory;
            this.getMultipleParameterDescription(description, multipleFactory, true);
            description.append("<br>");
            this.getMultipleParameterDescription(description, multipleFactory, false);
        } else {
            ParameterDocumentation doc = this.registry.getParameterDocumentation((IElementStructure)factory.getParameterStructures().get(0), this.locale);
            this.getTitleAndDescription(description, doc);
            ArrayList attributes = new ArrayList(structure.getAttributes());
            attributes.sort(Comparator.comparing(IElementAttribute::isOptional).thenComparing(IElementAttribute::getName));
            if (!attributes.isEmpty()) {
                description.append("<p style='margin-left:" + DEFAULT_MARGIN + "px'>");
                description.append(LNG.get((String)"ParametersDescriptionDialog.attributes"));
                description.append("</p'>");
                description.append(this.getAttributes(structure, attributes, doc, 1));
            }
        }
        return description.toString();
    }

    private void getMultipleParameterDescription(StringBuilder description, MultipleParameterFactory multipleFactory, Boolean value) {
        ParameterDocumentation doc = this.registry.getParameterDocumentation((IElementStructure)multipleFactory.getParameterStructure(value.booleanValue()), this.locale);
        description.append("<h3 style='margin-left:" + MULTIPLE_VALUES_MARGIN + "px'>");
        description.append(" " + MessageFormat.format(LNG.get((String)"ParametersDescriptionDialog.attribute.structure"), multipleFactory.getAttribute().getName(), value.toString()));
        description.append("</h3>");
        this.getTitleAndDescription(description, doc);
        description.append("<p style='margin-left:" + DEFAULT_MARGIN + "px'>");
        description.append(LNG.get((String)"ParametersDescriptionDialog.attributes"));
        description.append("</p>");
        description.append(this.getAttributes((IElementStructure<?>)multipleFactory.getParameterStructure(true), multipleFactory.getParameterStructure(true).getAttributes(), doc, 1));
    }

    private void getTitleAndDescription(StringBuilder description, ParameterDocumentation doc) {
        if (doc.getTitle() != null || doc.getDescription() != null) {
            description.append("</br>");
            description.append("<p style='margin-left:" + DEFAULT_MARGIN + "px'>");
        }
        if (doc.getTitle() != null) {
            description.append("<b>" + doc.getTitle() + "</b>");
        }
        if (doc.getDescription() != null) {
            description.append("<br>" + doc.getDescription());
        }
        if (doc.getTitle() != null || doc.getDescription() != null) {
            description.append("</p");
        }
    }

    private String getAttributes(IElementStructure<?> structure, List<IElementAttribute<?>> attributes, ParameterDocumentation doc, int marginLevel) {
        List children;
        StringBuilder description = new StringBuilder();
        if (!attributes.isEmpty()) {
            description.append("<ul style='margin-left:" + ATTRIBUTE_MARGIN * marginLevel + "px'>");
        }
        for (IElementAttribute<?> attribute : attributes) {
            String attributeDescription;
            description.append("<li>");
            description.append("<b>");
            description.append(attribute.getName());
            description.append("</b>");
            if (!attribute.isOptional()) {
                description.append("*");
            }
            description.append(" ");
            description.append(" (");
            if (attribute.getType().isEnum()) {
                T[] values = attribute.getType().getEnumConstants();
                for (int i = 0; i < values.length; ++i) {
                    description.append(values[i]);
                    if (i >= values.length - 1) continue;
                    description.append("|");
                }
            } else {
                description.append(attribute.getType().getSimpleName());
            }
            description.append(") ");
            if (attribute.isOptional()) {
                description.append(LNG.get((String)"ParametersDescriptionDialog.default"));
                description.append(" <i>");
                description.append(attribute.getDefaultValue());
                description.append("</i>");
            }
            if (doc != null && (attributeDescription = doc.getAttribute(attribute.getName())) != null) {
                description.append("<br>" + attributeDescription + "<br>");
            }
            description.append("</li>");
        }
        if (!attributes.isEmpty()) {
            description.append("</ul>");
        }
        if (!(children = structure.getChildElements()).isEmpty()) {
            description.append("<h2 style='margin-left:" + DEFAULT_MARGIN + "px'>");
            description.append(LNG.get((String)"ParametersDescriptionDialog.child.elements"));
            description.append("</h2>");
            for (IElementStructure child : children) {
                description.append(this.getChildDescription(child));
            }
        }
        return description.toString();
    }

    private String getChildDescription(IElementStructure<?> structure) {
        ArrayList attributes = new ArrayList(structure.getAttributes());
        attributes.sort(Comparator.comparing(IElementAttribute::isOptional).thenComparing(IElementAttribute::getName));
        StringBuilder description = new StringBuilder();
        description.append("<h3 style='margin-left:" + CHILDREN_TITLE_MARGIN + "px'>");
        description.append(structure.getName());
        description.append("</h3>");
        ParameterDocumentation doc = this.registry.getParameterDocumentation(structure, this.locale);
        if (doc.getTitle() != null) {
            description.append(doc.getTitle() + " - ");
        }
        if (doc.getDescription() != null) {
            description.append(doc.getDescription());
        }
        if (!attributes.isEmpty()) {
            description.append("<p style='margin-left:" + CHILDREN_CONTENT_MARGIN + "px'>");
            description.append(LNG.get((String)"ParametersDescriptionDialog.attributes"));
            description.append("</p>");
        }
        description.append(this.getAttributes(structure, attributes, doc, 2));
        return description.toString();
    }

    private void updateTextArea(String content) {
        StringBuilder builder = new StringBuilder("<html>");
        builder.append(content);
        builder.append("<br><br>");
        builder.append("</html>");
        this.textArea.setText(builder.toString());
        this.textArea.setCaretPosition(0);
    }

    private void mountPanel() {
        JPanel contentPanel = new JPanel();
        this.textArea = new JEditorPane();
        this.textArea.setFont(new Font("Monospaced", 0, this.textArea.getFont().getSize()));
        this.textArea.setEditable(false);
        HTMLEditorKit kit = new HTMLEditorKit();
        this.textArea.setEditorKit(kit);
        Document doc = kit.createDefaultDocument();
        this.textArea.setDocument(doc);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setMinimumSize(new Dimension(800, 600));
        scrollPane.setPreferredSize(new Dimension(800, 600));
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setBorder(BorderFactory.createEtchedBorder());
        contentPanel.setLayout(new GridBagLayout());
        contentPanel.add((Component)scrollPane, new GBC(0, 0).both().insets(6, 6, 6, 6));
        this.setContentPane(contentPanel);
    }
}

