/*
 * $Id: LogViewerAction.java 69058 2007-10-15 17:34:47Z clinio $
 */
package csbase.client.applications.csvviewer.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.ApplicationAction;
import csbase.client.applications.csvviewer.CSVViewer;
import csbase.client.util.StandardErrorDialogs;

/**
 * @author Tecgraf/PUC-Rio
 */
public abstract class AbstractCSVAction extends ApplicationAction<CSVViewer> {

  /**
   * Tag usado para buscar o nome da ao.
   */
  final static protected String TAG_NAME = "name";

  /**
   * Tag usado para buscar o mnemnico da ao.
   */
  final static protected String TAG_MNEMONIC = "mnemonic";

  /**
   * Tag usado para buscar o tooltip da ao.
   */
  final static protected String TAG_TOOLTIP = "tooltip";

  /**
   * Construtor
   * 
   * @param application o aplicativo dono dessa ao.
   * @param icon a imagem da ao.
   */
  protected AbstractCSVAction(CSVViewer application, ImageIcon icon) {
    this(application);
    putValue(Action.SMALL_ICON, icon);
  }

  /**
   * Construtor
   * 
   * @param application o aplicativo dono dessa ao.
   */
  protected AbstractCSVAction(CSVViewer application) {
    super(application);

    final String name = getName();
    if (name != null) {
      putValue(Action.NAME, name);
    }

    final Integer mnemonic = getMnemonic();
    if (mnemonic != null) {
      putValue(Action.MNEMONIC_KEY, mnemonic);
    }

    final String tooltip = getToolTipText();
    if (tooltip != null) {
      putValue(Action.SHORT_DESCRIPTION, tooltip);
    }
  }

  /**
   * {@inheritDoc} Repasse para outro mtodo com encapsulamento de excees.
   * 
   * @see #actionDone(JComponent)
   */
  @Override
  public void actionPerformed(ActionEvent ae) {
    try {
      final JComponent cmp = (JComponent) ae.getSource();
      actionDone(cmp);
    }
    catch (Exception e) {
      final Window window = getApplication().getApplicationFrame();
      final String title = getApplication().getName();
      StandardErrorDialogs.showErrorDialog(window, title, e);
    }
  }

  /**
   * Mtodo de consulta ao texto de <i>tooltip</i> da ao montado no padro "
   * <code>NomeDaClasse.NAME_SUFIX</code>"
   * 
   * @return o texto (nome) da ao.
   */
  public final String getName() {
    return getApplication().getString(
      getClass().getSimpleName() + "." + TAG_NAME);
  }

  /**
   * Mtodo de consulta ao texto de <i>tooltip</i> da ao montado no padro "
   * <code>NomeDaClasse.tooltip</code>"
   * 
   * @return o texto de tooltip
   */
  public final String getToolTipText() {
    return getApplication().getString(
      getClass().getSimpleName() + "." + TAG_TOOLTIP);
  }

  /**
   * Consulta ao mnemnico da ao.
   * 
   * @return o mnemnico
   */
  private final Integer getMnemonic() {
    final String mn =
      getApplication().getString(
        getClass().getSimpleName() + "." + TAG_MNEMONIC);
    if (mn == null || "".equals(mn)) {
      return null;
    }

    return Integer.valueOf(mn.charAt(0));
  }

  /**
   * Mtodo de ao a ser definido dentro do Planref.
   * 
   * @param component o componente que ativou a ao.
   * 
   * @throws Exception se houver falha na ao.
   */
  public abstract void actionDone(JComponent component) throws Exception;

}
